import { computed, defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/common/quick-search/quick-search.scss';

export const QuickSearch = defineComponent({
  name: 'QuickSearch',
  props: {
    value: {
      type: String,
    },
    viewMode: {
      type: String,
      required: true,
    },
    placeholder: {
      type: String,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('quick-search');
    const inputValue = computed({
      get() {
        return props.value;
      },
      set(val: string | undefined) {
        emit('update', val!);
      },
    });
    const search = () => {
      emit('search');
    };
    const onChange = (e: InputEvent) => {
      if (e.target) {
        inputValue.value = (e.target as unknown as { value: string }).value;
      }
    };
    return { ns, inputValue, search, onChange };
  },
  render() {
    return (
      <i-input
        value={this.value}
        class={[this.ns.b(), this.ns.m(this.viewMode.toLowerCase())]}
        search={true}
        placeholder={this.placeholder}
        on-on-change={this.onChange}
        on-on-enter={this.search}
        on-on-search={this.search}
      ></i-input>
    );
  },
});

export default QuickSearch;
