import { ReginfoBaseService } from './reginfo-base.service';

/**
 * 学员登记信息服务
 *
 * @export
 * @class ReginfoService
 * @extends {ReginfoBaseService}
 */
export class ReginfoService extends ReginfoBaseService {
    /**
     * Creates an instance of ReginfoService.
     * @memberof ReginfoService
     */
    constructor(opts?: any) {
        const { context: context, tag: cacheKey } = opts;
        super(context);
        if (___ibz___.sc.has(cacheKey)) {
            return ___ibz___.sc.get(cacheKey);
        }
        ___ibz___.sc.set(cacheKey, this);
    }

    /**
     * 获取实例
     *
     * @static
     * @param 应用上下文
     * @return {*}  {ReginfoService}
     * @memberof ReginfoService
     */
    static getInstance(context?: any): ReginfoService {
        const cacheKey: string = context?.srfdynainstid ? `${context.srfdynainstid}ReginfoService` : `ReginfoService`;
        if (!___ibz___.sc.has(cacheKey)) {
            new ReginfoService({ context: context, tag: cacheKey });
        }
        return ___ibz___.sc.get(cacheKey);
    }
}
export default ReginfoService;
