import { CodeListService } from '../app/codelist-service';
import { EntityBaseService, IContext, HttpResponse } from 'ibiz-core';
import { GlobalService } from '../global.service';
import { IReginfo, Reginfo } from '../../entities';
import keys from '../../entities/reginfo/reginfo-keys';
import { ReginfoDTOHelp } from '../../entities/reginfo/reginfo-dto-help';


/**
 * 学员登记信息服务对象基类
 *
 * @export
 * @class ReginfoBaseService
 * @extends {EntityBaseService}
 */
export class ReginfoBaseService extends EntityBaseService<IReginfo> {
    protected get keys(): string[] {
        return keys;
    }
    protected SYSTEMNAME = 'TrainSys';
    protected APPNAME = 'Web';
    protected APPDENAME = 'Reginfo';
    protected APPWFDENAME = 'REGINFO';
    protected APPDENAMEPLURAL = 'Reginfos';
    protected dynaModelFilePath:string = 'PSSYSAPPS/Web/PSAPPDATAENTITIES/Reginfo.json';
    protected APPDEKEY = 'reginfoid';
    protected APPDETEXT = 'reginfoname';
    protected quickSearchFields = ['reginfoname',];
    protected selectContextParam = {
    };

    constructor(opts?: any) {
        super(opts, 'Reginfo');
    }

    newEntity(data: IReginfo): Reginfo {
        return new Reginfo(data);
    }

    /**
     * Create
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async Create(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Create');
        if (!_data.srffrontuf || _data.srffrontuf != 1) {
            _data[this.APPDEKEY] = null;
        }
        if (_data.srffrontuf != null) {
            delete _data.srffrontuf;
        }
        _data = await ReginfoDTOHelp.get(_context,_data);
        const res = await this.http.post(`/reginfos`, _data);
        res.data = await ReginfoDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Get
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async Get(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.get(`/reginfos/${encodeURIComponent(_context.reginfo)}`, _data);
        res.data = await ReginfoDTOHelp.set(_context,res.data);
        res.data = await this.afterExecuteAction(_context,res?.data,'Get');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * GetDraft
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async GetDraft(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data[this.APPDENAME?.toLowerCase()] = undefined;
        _data[this.APPDEKEY] = undefined;
        const res = await this.http.get(`/reginfos/getdraft`, _data);
        res.data = await ReginfoDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Remove
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async Remove(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.delete(`/reginfos/${encodeURIComponent(_context.reginfo)}`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Update
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async Update(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Update');
        _data = await ReginfoDTOHelp.get(_context,_data);
        const res = await this.http.put(`/reginfos/${encodeURIComponent(_context.reginfo)}`, _data);
        res.data = await ReginfoDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * FetchDefault
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async FetchDefault(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/reginfos/fetchdefault`, _data);
        res.data = await ReginfoDTOHelp.ToDataObjArray(_context,res.data);
        res.data = await this.afterExecuteActionBatch(_context,res?.data,'FetchDefault');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Select
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof ReginfoService
     */
    async Select(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/reginfos/select`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
}
