import { BookBaseService } from './book-base.service';

/**
 * 书服务
 *
 * @export
 * @class BookService
 * @extends {BookBaseService}
 */
export class BookService extends BookBaseService {
    /**
     * Creates an instance of BookService.
     * @memberof BookService
     */
    constructor(opts?: any) {
        const { context: context, tag: cacheKey } = opts;
        super(context);
        if (___ibz___.sc.has(cacheKey)) {
            return ___ibz___.sc.get(cacheKey);
        }
        ___ibz___.sc.set(cacheKey, this);
    }

    /**
     * 获取实例
     *
     * @static
     * @param 应用上下文
     * @return {*}  {BookService}
     * @memberof BookService
     */
    static getInstance(context?: any): BookService {
        const cacheKey: string = context?.srfdynainstid ? `${context.srfdynainstid}BookService` : `BookService`;
        if (!___ibz___.sc.has(cacheKey)) {
            new BookService({ context: context, tag: cacheKey });
        }
        return ___ibz___.sc.get(cacheKey);
    }
}
export default BookService;
