
/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * UIServiceRegister 单例对象
     *
     * @private
     * @static
     * @memberof UIServiceRegister
     */
    private static UIServiceRegister:UIServiceRegister;

    /**
     * 所有UIService Map对象
     *
     * @private
     * @static
     * @memberof UIServiceRegister
     */    
    private static allUIServiceMap:Map<string,any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 获取UIServiceRegister 单例对象
     *
     * @public
     * @static
     * @memberof UIServiceRegister
     */
    public static getInstance(){
        if(!this.UIServiceRegister){
            this.UIServiceRegister = new UIServiceRegister();
        }
        return this.UIServiceRegister;
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                UIServiceRegister.allUIServiceMap.set('phone', () => import('../uiservice/phone/phone-ui-service'));
        UIServiceRegister.allUIServiceMap.set('rawmaterial', () => import('../uiservice/raw-material/raw-material-ui-service'));
        UIServiceRegister.allUIServiceMap.set('book', () => import('../uiservice/book/book-ui-service'));
        UIServiceRegister.allUIServiceMap.set('reginfo', () => import('../uiservice/reginfo/reginfo-ui-service'));
    }

    /**
     * 获取指定UIService
     *
     * @public
     * @memberof UIServiceRegister
     */
    public async getService(context:any,entityKey:string){
        const importService = UIServiceRegister.allUIServiceMap.get(entityKey);
        if(importService){
            const importModule = await importService();
            return importModule.default.getInstance(context);
        }
    }

}