/**
 * 实体权限服务注册中心
 *
 * @export
 * @class AuthServiceRegister
 */
export class AuthServiceRegister{

    /**
     * AuthServiceRegister 单例对象
     *
     * @private
     * @static
     * @memberof AuthServiceRegister
     */
    private static AuthServiceRegister: AuthServiceRegister;

    /**
     * 所有AuthService Map对象
     *
     * @private
     * @static
     * @memberof AuthServiceRegister
     */
    private static allAuthServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of AuthServiceRegister.
     * @memberof AuthServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 获取allAuthServiceMap 单例对象
     *
     * @public
     * @static
     * @memberof AuthServiceRegister
     */
    public static getInstance() {
        if (!this.AuthServiceRegister) {
            this.AuthServiceRegister = new AuthServiceRegister();
        }
        return this.AuthServiceRegister;
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof AuthServiceRegister
     */
    protected init(): void {
                AuthServiceRegister.allAuthServiceMap.set('phone', () => import('../authservice/phone/phone-auth-service'));
        AuthServiceRegister.allAuthServiceMap.set('rawmaterial', () => import('../authservice/raw-material/raw-material-auth-service'));
        AuthServiceRegister.allAuthServiceMap.set('book', () => import('../authservice/book/book-auth-service'));
        AuthServiceRegister.allAuthServiceMap.set('reginfo', () => import('../authservice/reginfo/reginfo-auth-service'));
    }

    /**
     * 获取指定AuthService
     *
     * @public
     * @memberof UIServiceRegister
     */
    public async getService(context: any, entityKey: string) {
        const importService = AuthServiceRegister.allAuthServiceMap.get(entityKey);
        if (importService) {
            const importModule = await importService();
            return importModule.default.getInstance(context);
        }
    }

}