/**
 * 全局服务
 *
 * @export
 * @class GlobalService
 */
export class GlobalService {

    /**
     * 获取数据服务
     * 
     * @param name 实体名称
     * @param context 应用上下文
     * memberof GlobalService
     */
    public async getService(name:string, context?: any){
        const targetService:any = await (this as any)[`get${name}Service`](context);
        await targetService.loaded(context);
        return targetService;
    }

    /**
     * 手机服务
     *
     * @param context 应用上下文
     * @return {Phone}
     * @memberof GlobalService
     */
    async getPhoneService(context?: any) {
        return (await import('./phone/phone.service')).default.getInstance(context);
    }
    /**
     * 原材料服务
     *
     * @param context 应用上下文
     * @return {RawMaterial}
     * @memberof GlobalService
     */
    async getRawMaterialService(context?: any) {
        return (await import('./raw-material/raw-material.service')).default.getInstance(context);
    }
    /**
     * 书服务
     *
     * @param context 应用上下文
     * @return {Book}
     * @memberof GlobalService
     */
    async getBookService(context?: any) {
        return (await import('./book/book.service')).default.getInstance(context);
    }
    /**
     * 学员登记信息服务
     *
     * @param context 应用上下文
     * @return {Reginfo}
     * @memberof GlobalService
     */
    async getReginfoService(context?: any) {
        return (await import('./reginfo/reginfo.service')).default.getInstance(context);
    }
}
