import { EntityBase } from 'ibiz-core';
import { IPhone } from '../interface';

/**
 * 手机基类
 *
 * @export
 * @abstract
 * @class PhoneBase
 * @extends {EntityBase}
 * @implements {IPhone}
 */
export abstract class PhoneBase extends EntityBase implements IPhone {
    /**
     * 实体名称
     *
     * @readonly
     * @type {string}
     * @memberof PhoneBase
     */
    get srfdename(): string {
        return 'PHONE';
    }
    get srfkey() {
        return this.phoneid;
    }
    set srfkey(val: any) {
        this.phoneid = val;
    }
    get srfmajortext() {
        return this.phonename;
    }
    set srfmajortext(val: any) {
        this.phonename = val;
    }
    /**
     * 手机标识
     */
    phoneid?: any;
    /**
     * 建立时间
     */
    createdate?: any;
    /**
     * 手机名称
     */
    phonename?: any;
    /**
     * 建立人
     */
    createman?: any;
    /**
     * 更新时间
     */
    updatedate?: any;
    /**
     * 更新人
     */
    updateman?: any;
    /**
     * 组织部门标识
     */
    deptid?: any;
    /**
     * 组织机构标识
     */
    orgid?: any;
    /**
     * 手机型号
     */
    phonetype?: any;

    /**
     * 重置实体数据
     *
     * @private
     * @param {*} [data={}]
     * @memberof PhoneBase
     */
    reset(data: any = {}): void {
        super.reset(data);
        this.phoneid = data.phoneid || data.srfkey;
        this.phonename = data.phonename || data.srfmajortext;
    }
}
