import { AppServiceBase, AuthServiceBase } from 'ibiz-core';

/**
 * 实体权限服务
 *
 * @export
 * @class AuthService
 */
export class AuthService extends AuthServiceBase {

    /**
     * 默认操作标识
     *
     * @public
     * @type {(any)}
     * @memberof AuthService
     */
    public defaultOPPrivs: any = {CREATE: 1,DELETE: 1,DENY: 1,NONE: 1,READ: 1,UPDATE: 1,WFSTART: 1}; 

    /**
     * Creates an instance of AuthService.
     * 
     * @param {*} [opts={}]
     * @memberof AuthService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 注册系统操作标识统一资源
     *
     * @param {string} name 实体名称
     * @returns {Promise<any>}
     * @memberof AuthService
     */ 
    public registerSysOPPrivs(){
    }

    /**
     * 根据菜单项获取菜单权限
     *
     * @param {*} item 菜单标识
     * @returns {boolean}
     * @memberof AuthService
     */
    public getMenusPermission(item: any): boolean {
        const Environment = AppServiceBase.getInstance().getAppEnvironment();
        if(!this.getStore().getters['authresource/getEnablePermissionValid']) {
            return true;
        }
        if(Object.is(Environment.menuPermissionMode,"RT")){
            return this.getStore().getters['authresource/getAuthMenuWithRT'](item);
        }else if(Object.is(Environment.menuPermissionMode,"RESOURCE")){
            return this.getStore().getters['authresource/getAuthMenuWithResource'](item);
        }else{
            return this.getStore().getters['authresource/getAuthMenu'](item);
        }
    }

}