import { FormTabPanelController } from '@ibiz-template/controller';
import { FormTabPanelModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, ref, VNode } from 'vue';

export default defineComponent({
  name: 'FormTabPanel',
  props: {
    modelData: {
      type: FormTabPanelModel,
      required: true,
    },
    controller: {
      type: FormTabPanelController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-tab-panel');
    // tabs标识，嵌套时区分用
    const tabName = ref(props.modelData.source.name);
    return { ns, tabName };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    return (
      <i-tabs class={[this.ns.b()]} name={this.tabName}>
        {defaultSlots.map(slot => {
          if (!slot.componentOptions) {
            return slot;
          }
          const { modelData } = (slot.componentOptions.propsData ||
            {}) as IData;
          return (
            <i-tab-pane
              class={this.ns.b('tab-item')}
              tab={this.tabName}
              label={modelData.source.caption}
              name={modelData.id}
            >
              {slot}
            </i-tab-pane>
          );
        })}
      </i-tabs>
    );
  },
});
