/* eslint-disable no-nested-ternary */
import { ref, watch, defineComponent } from 'vue';
import {
  getDatePickerProps,
  getEditorEmits,
  useNamespace,
} from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/editor/ibiz-date-picker/ibiz-date-picker.scss';
import dayjs from 'dayjs';

export const IBizDatePicker = defineComponent({
  name: 'IBizDatePicker',
  props: getDatePickerProps(),
  emits: getEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('date-picker');
    const c = props.controller;

    const editorModel = c!.model;

    const type = ref('date');
    const format = ref('yyyy-MM-dd');

    const isTimePicker = ref(false);

    switch (editorModel.editorType) {
      case 'DATEPICKEREX':
      case 'DATEPICKEREX_NOTIME':
        type.value = 'date';
        break;
      case 'DATEPICKEREX_NODAY':
      case 'DATEPICKEREX_NODAY_NOSECOND':
        isTimePicker.value = true;
        type.value = 'time';
        break;
      case 'DATEPICKEREX_HOUR':
      case 'DATEPICKEREX_MINUTE':
      case 'DATEPICKEREX_SECOND':
      case 'DATEPICKEREX_NOSECOND':
      case 'DATEPICKER':
      default:
        type.value = 'datetime';
    }
    // 值格式化
    const valueFormat = c!.valueFormat;
    if (valueFormat) {
      // 根据值格式化改变type
      if (valueFormat === 'YYYY-MM') {
        type.value = 'month';
      } else if (valueFormat === 'YYYY') {
        type.value = 'year';
      }
      const tempFormat: string = valueFormat
        .replace('YYYY', 'yyyy')
        .replace('DD', 'dd');
      format.value = tempFormat;
    }
    const formatValue = ref();
    watch(
      () => props.value,
      (newVal, oldVal) => {
        // 空值不转换
        if (newVal && newVal !== oldVal) {
          formatValue.value = dayjs(newVal).format(valueFormat);
        }
      },
      { immediate: true },
    );
    // 处理值变更
    const handleChange = (date: string, _dateType: IData) => {
      emit('change', date);
    };

    const onOpenChange = (isOpen: boolean) => {
      emit('operate', isOpen);
    };

    const inputRef = ref();

    if (props.autoFocus) {
      watch(inputRef, newVal => {
        if (newVal) {
          const input = newVal.$el.getElementsByTagName('input')[0];
          input.click();
        }
      });
    }

    return {
      ns,
      c,
      editorModel,
      type,
      format,
      formatValue,
      handleChange,
      onOpenChange,
      inputRef,
      isTimePicker,
    };
  },
  render(h) {
    return (
      <div
        class={[
          this.ns.b(),
          this.disabled ? this.ns.m('disabled') : '',
          this.readonly ? this.ns.m('readonly') : '',
        ]}
      >
        {[
          this.readonly && this.formatValue,
          !this.readonly &&
            this.isTimePicker &&
            h('ITimePicker', {
              ref: 'inputRef',
              props: {
                ...this.c.customProps,
                value: this.value,
                type: this.type,
                format: this.format,
                placeholder: this.c!.placeHolder,
                disabled: this.disabled,
                transfer: true,
              },
              on: {
                'on-change': this.handleChange,
                'on-open-change': this.onOpenChange,
              },
            }),
          !this.readonly &&
            !this.isTimePicker &&
            h('ICalendarPicker', {
              ref: 'inputRef',
              props: {
                ...this.c.customProps,
                value: this.value,
                type: this.type,
                format: this.format,
                placeholder: this.c!.placeHolder,
                disabled: this.disabled,
                transfer: true,
              },
              on: {
                'on-change': this.handleChange,
                'on-open-change': this.onOpenChange,
              },
            }),
        ]}
      </div>
    );
  },
});
