import Vue from 'vue';
import { IMessageUtil } from '@ibiz-template/runtime';
import { Message } from 'view-design';

/**
 * 消息通知
 *
 * @author chitanda
 * @date 2022-08-17 16:08:24
 * @export
 * @class MessageUtil
 * @implements {IMessageUtil}
 */
export class MessageUtil implements IMessageUtil {
  protected util: Message = Vue.prototype.$Message;

  info(
    msg: string,
    duration?: number | undefined,
    closable?: boolean | undefined,
  ): void {
    this.util.info({ content: msg, duration, closable });
  }

  success(
    msg: string,
    duration?: number | undefined,
    closable?: boolean | undefined,
  ): void {
    this.util.success({ content: msg, duration, closable });
  }

  warning(
    msg: string,
    duration?: number | undefined,
    closable?: boolean | undefined,
  ): void {
    this.util.warning({ content: msg, duration, closable });
  }

  error(
    msg: string,
    duration?: number | undefined,
    closable?: boolean | undefined,
  ): void {
    this.util.error({ content: msg, duration, closable });
  }
}
