import { IModal } from '@ibiz-template/runtime';
import { useAppPortalViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const AppPortalView = defineComponent({
  name: 'AppPortalView',
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useAppPortalViewController(proxy, props.modelPath);
    return { c };
  },
  render(h) {
    let dashboardComponent = null;
    if (this.c.complete) {
      const { dashboard } = this.c.model;
      if (this.c.providers[dashboard.name]) {
        dashboardComponent = h(this.c.providers[dashboard.name].component, {
          props: {
            modelData: dashboard,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(dashboard.name),
          },
        });
      }
    }
    return <view-base controller={this.c}>{dashboardComponent}</view-base>;
  },
});
