import { defineComponent } from 'vue';
import {
  getGridInputProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridInput = defineComponent({
  name: 'IBizGridInput',
  props: getGridInputProps(),
  setup(props) {
    const ns = useNamespace('grid-input');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: true,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizInput', {
          props: {
            ...this.$props,
            readonly: this.readonly || this.isInfoMode,
            disabled: this.disabled,
            autoFocus: true,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
