import { EditViewController } from '@ibiz-template/controller';
import { EditFormModel } from '@ibiz-template/model';
import { useEditFormController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const EditFormControl = defineComponent({
  name: 'EditFormControl',
  props: {
    controller: {
      type: Object as PropType<EditViewController>,
    },
    modelData: {
      type: EditFormModel,
      required: true,
    },
    context: { type: Object as PropType<IContext>, required: true },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    enableAutoSave: { type: Boolean, required: false },
    silentVerify: { type: Boolean, required: false },
    simpleDataIndex: { type: Number, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditFormController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );
    return { c };
  },

  render() {
    return !this.c.complete ? null : (
      <form-control
        model-data={this.modelData}
        context={this.context}
        controller={this.c}
      ></form-control>
    );
  },
});
