import { DropDownListModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/runtime';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { DropDownListEditorController } from '@ibiz-template/controller/src/editor';
/**
 * 多选框列表编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DropDownListEditorProvider
 * @implements {EditorProvider}
 */
export class DropDownListEditorProvider
  implements IEditorProvider<DropDownListEditorController>
{
  formEditor: string = 'IBizDropDownList';

  rowEditor: string = 'IBizDropDownList';

  async createController(
    editorModel: DropDownListModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<DropDownListEditorController> {
    const c = new DropDownListEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
