import { PickerEditorModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/runtime';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { PickerEditorController } from '@ibiz-template/controller/src/editor';
/**
 * 数据选择器编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DataPickerEditorProvider
 * @implements {EditorProvider}
 */
export class DataPickerEditorProvider
  implements IEditorProvider<PickerEditorController>
{
  formEditor: string;

  rowEditor: string;

  constructor(editorType: string) {
    let componentName = 'IBizPicker';
    switch (editorType) {
      case 'PICKEREX_TRIGGER':
        componentName = 'IBizPickerDropDown';
        break;
      case 'PICKEREX_LINK':
        componentName = 'AppPickerLinkOnly';
        break;
      case 'ADDRESSPICKUP':
        componentName = 'IBizMPicker';
        break;
      default:
    }
    this.formEditor = componentName;
    this.rowEditor = componentName;
  }

  async createController(
    editorModel: PickerEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<PickerEditorController> {
    const c = new PickerEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
