import { ILoadingUtil } from '@ibiz-template/runtime';
import Vue from 'vue';

/**
 * 全局加载动画工具
 *
 * @author chitanda
 * @date 2022-08-17 17:08:44
 * @export
 * @class LoadingUtil
 * @implements {ILoadingUtil}
 */
export class LoadingUtil implements ILoadingUtil {
  /**
   * 当前只在触发的全局加载次数
   *
   * @author chitanda
   * @date 2022-08-17 17:08:44
   * @protected
   */
  protected count = 0;

  /**
   * 显示全局加载动画
   *
   * @author chitanda
   * @date 2022-08-17 17:08:41
   * @param {string} [message='加载中...']
   */
  show(): void {
    if (this.count === 0) {
      Vue.prototype.$Spin.show();
    }
    this.count += 1;
  }

  /**
   * 隐藏全局加载动画
   *
   * @author chitanda
   * @date 2022-08-17 17:08:11
   */
  hide(): void {
    if (this.count > 0) {
      this.count -= 1;
    }
    if (this.count === 0) {
      Vue.prototype.$Spin.hide();
    }
  }
}
