import Router from 'vue-router';
import { AuthGuard } from '../guard';
import RouterShell from '@/components/router-shell/router-shell';

const router = new Router({
  routes: [
    {
      path: '/',
      redirect: '/index',
    },
    {
      path: '/login',
      name: 'loginView',
      component: () => import('../views/login-view/login-view'),
    },
    {
      path: '/404',
      name: '404View',
      component: () => import('../views/404-view/404-view'),
    },
    {
      path: '/:view1([^=/]+)/:params1([^/]+=[^/]+)?',
      props: {
        level: 1,
      },
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: RouterShell,
      children: [
        {
          path: ':view2([^=/]+)/:params2([^/]+=[^/]+)?',
          props: {
            level: 2,
          },
          component: RouterShell,
          children: [
            {
              path: ':view3([^=/]+)/:params3([^/]+=[^/]+)?',
              props: {
                level: 3,
              },
              component: RouterShell,
            },
          ],
        },
      ],
    },
    {
      path: '*',
      redirect: '/404',
    },
  ],
});

export default router;
