import { defineComponent } from 'vue';
import type { PropType } from 'vue';
import { SpanEditorController } from '@ibiz-template/controller';
import { useNamespace } from '@ibiz-template/vue-util';
import '@/styles/components/editor/ibiz-span/ibiz-span.scss';

export default defineComponent({
  props: {
    value: String,
    controller: {
      type: SpanEditorController,
      required: true,
    },
    data: {
      type: Object as PropType<IData>,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('span');

    return {
      ns,
    };
  },
  render() {
    return <span class={this.ns.b()}>{this.value}</span>;
  },
});
