
/**
 * 视图基类接口
 *
 * @interface ViewInterface
 */
export interface ViewInterface {

    /**
     *  视图初始化
     *
     * @memberof ViewInterface
     */
    viewInit(): void;


    /**
     * 视图销毁
     *
     * @memberof ViewInterface
     */
    viewDestroyed(): void;

    /**
     * 视图刷新
     *
     * @param {*} [args]
     * @memberof ViewInterface
     */
    refresh(args?: any): void;

    /**
     * 关闭视图
     *
     * @param {any[]} args 关闭
     * @memberof ViewInterface
     */
    closeView(args: any[]): void;


    /**
     * 部件事件
     * 
     * @param controlname 部件名称
     * @param action  行为
     * @param data 数据
     * @memberof ViewInterface
     */
    onCtrlEvent(controlname: string, action: string, data: any): void;


    /**
     * 初始化模型服务
     *
     * @memberof ViewInterface
     */
    initModelService(): void;


    /**
     * 初始化沙箱实例
     * 
     * @param {*} args
     * @memberof ViewInterface
     */
    initSandBoxInst(args: any): void;

    /**
     * 解析视图参数
     *
     * @param {*} inputvalue 额外参数
     * @memberof ViewInterface
     */
    parseViewParam(inputvalue: any): void;

}
