import { safeRedirect } from '@ibiz-template/runtime';
import { LoginMode, RuntimeError } from '@ibiz-template/core';
import router from '@/router';

/**
 * 没有权限的处理器
 *
 * @author lxm
 * @date 2022-10-11 14:10:10
 * @export
 * @class UnauthorizedHandler
 */
export class UnauthorizedHandler {
  /**
   * cas登录处理
   *
   * @author lxm
   * @date 2022-10-11 14:10:35
   * @protected
   * @static
   * @returns {*}  {Promise<void>}
   */
  protected static async casLogin(): Promise<void> {
    if (!ibiz.env.casLoginUrl) {
      throw new RuntimeError('找不到环境参数casLoginUrl');
    }
    // 跳转cas登录地址
    safeRedirect(ibiz.env.casLoginUrl, { type: 'href' });
  }

  /**
   * 普通登录处理
   *
   * @author lxm
   * @date 2022-10-11 14:10:24
   * @protected
   * @static
   * @returns {*}  {Promise<void>}
   */
  protected static async normalLogin(): Promise<void> {
    // 禁止跳转登录视图时不处理
    if (!ibiz.env.disabledLogin) {
      const ru = window.location.hash.replace('#', '');
      router.push({ path: '/login', query: { ru } });
    }
  }

  /**
   * 没有权限处理
   *
   * @author lxm
   * @date 2022-10-11 14:10:50
   * @static
   * @returns {*}  {Promise<void>}
   */
  static async handle(): Promise<void> {
    if (ibiz.env.loginMode === LoginMode.CAS) {
      await this.casLogin();
    } else {
      this.normalLogin();
    }
  }
}
