import { RadioButtonListModel } from '@ibiz-template/model';
import {
  FormItemController,
  GridEditItemController,
  IEditorProvider,
  RadioButtonListEditorController,
} from '@ibiz-template/controller';
/**
 * 单选框列表编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class RadioButtonListEditorProvider
 * @implements {EditorProvider}
 */
export class RadioButtonListEditorProvider implements IEditorProvider {
  formEditor: string = 'IBizRadio';

  gridEditor: string = 'IBizGridRadio';

  async createController(
    editorModel: RadioButtonListModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<RadioButtonListEditorController> {
    const c = new RadioButtonListEditorController(
      editorModel,
      parentController,
    );
    await c.init();
    return c;
  }
}
