import { defineComponent, ref, VNode } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import { FormModel } from '@ibiz-template/model';
import '@ibiz-template/theme/style/components/widgets/form/form-page.scss';

export const FormPage = defineComponent({
  name: 'FormPage',
  props: {
    modelData: {
      type: FormModel,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-page');
    // tabs标识，嵌套时区分用
    const tabName = ref(props.modelData.source.name);
    return { ns, tabName };
  },
  render() {
    const { noTabHeader } = this.modelData.source;
    const defaultSlots: VNode[] = this.$slots.default || [];
    if (defaultSlots.length === 1 || noTabHeader) {
      return (
        <div class={(this.ns.b(), this.ns.m('no-tab-header'))}>
          {defaultSlots}
        </div>
      );
    }
    return (
      <i-tabs class={[this.ns.b(), this.ns.b('tab')]} name={this.tabName}>
        {defaultSlots.map(slot => {
          const opts = slot.componentOptions!;
          const props = (opts.propsData || {}) as Record<string, unknown>;
          return (
            <i-tab-pane
              class={this.ns.b('tab-item')}
              tab={this.tabName}
              label={props.caption}
              name={slot.key}
            >
              {slot}
            </i-tab-pane>
          );
        })}
      </i-tabs>
    );
  },
});

export default FormPage;
