import { IPSDEUILogicParam, IPSDEUIRenewParamLogic } from '@ibiz/dynamic-model-api';
import { UIActionContext } from '../uiaction-context';
import { AppUILogicNodeBase } from './logic-node-base';
/**
 * 重新建立参数节点
 *
 * @export
 * @class AppUILogicReNewParamNode
 */
export class AppUILogicReNewParamNode extends AppUILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {IPSDEUIRenewParamLogic} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof AppUILogicReNewParamNode
     */
    public async executeNode(logicNode: IPSDEUIRenewParamLogic, actionContext: UIActionContext) {
        try {
            this.onRenewParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error?.message ? error?.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处理参数
     *
     * @param {IPSDEUIRenewParamLogic} logicNode 节点模型数据
     * @param {UIActionContext} actionContext  逻辑上下文
     * @memberof AppUILogicReNewParamNode
     */
    public onRenewParam(logicNode: IPSDEUIRenewParamLogic, actionContext: UIActionContext) {
        if (!logicNode || !logicNode.getDstPSDEUILogicParam()) {
            throw new Error(`操作参数缺失！`);
        }
        try {
            // 目标数据
            const dstParam: any = actionContext.getParam((logicNode.getDstPSDEUILogicParam() as IPSDEUILogicParam)?.codeName);
            dstParam.renew();
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数${logicNode.getDstPSDEUILogicParam()?.name}${error?.message ? error?.message : '发生未知错误！'}`);
        }
    }
}