var ae = Object.defineProperty;
var re = (e, t, s) => t in e ? ae(e, t, { enumerable: !0, configurable: !0, writable: !0, value: s }) : e[t] = s;
var T = (e, t, s) => (re(e, typeof t != "symbol" ? t + "" : t, s), s);
import { IndexViewModel as le, ViewType as ce, ModelUtil as de } from "@ibiz-template/model";
import { GridFieldColumnController as q, GridRowController as ue, WFStepTraceViewController as me, UploadEditorController as H, WFDynaEditView3Controller as pe } from "@ibiz-template/controller";
import { defineComponent as U, computed as L, h as a, getCurrentInstance as B, ref as b, watch as S, toRefs as G } from "vue";
import { useNamespace as E, useViewController as X, usePropsWatch as J, getUploadProps as he, getEditorEmits as K, getGridUploadProps as R, getGridEditorEmits as _, useClickOutside as fe, useEventListener as be, getInputProps as ve, getGridInputProps as ye, useGridCellEditor as we, useWFStepTraceViewController as ge, useEditView3Controller as Fe } from "@ibiz-template/vue-util";
import { colorBlend as Ce, HttpError as Y, isImage as Ue, uploadFile as Ee, RuntimeError as xe } from "@ibiz-template/core";
import { getCookie as Se, createUUID as W } from "qx-util";
import { debounce as ke } from "lodash-es";
import { ViewMode as Q, PluginStaticResource as Te } from "@ibiz-template/runtime";
const Pe = U({
  name: "CodeListGridColumn",
  props: {
    controller: {
      type: q,
      required: !0
    },
    row: {
      type: ue,
      required: !0
    }
  },
  setup(e) {
    const t = E("grid-field-column"), s = L(() => {
      var l;
      if (e.controller.model.source.cLConvertMode !== "FRONT")
        return [];
      const n = e.row.data[e.controller.model.codeName];
      return (l = e.controller.codeListItems) != null && l.length && n ? n.split(",").map((p) => {
        const h = e.controller.codeListItems.find((f) => f.value === p);
        if (h) {
          const f = h.color || "#515a6e";
          return {
            text: h.text,
            colorStyle: t.cssVarBlock({
              color: f,
              "border-color": f,
              "bg-color": Ce(f, "#fff")
            })
          };
        }
      }).filter(Boolean) : [];
    }), o = (n) => {
      e.controller.isLinkColumn && e.controller.openLinkView(e.row, n);
    }, i = L(() => {
      let n = "";
      switch (e.controller.model.align) {
        case "LEFT":
          n = "flex-start";
          break;
        case "RIGHT":
          n = "flex-end";
          break;
        default:
          n = "center";
          break;
      }
      return t.cssVarBlock({
        "justify-content": n
      });
    });
    return {
      ns: t,
      alignStyle: i,
      selectedItems: s,
      onCellClick: o
    };
  },
  render() {
    const e = this.controller, t = this.row.data[e.model.codeName];
    return a("div", {
      class: [this.ns.b(), e.isLinkColumn && this.ns.m("link-column")],
      style: this.alignStyle,
      on: {
        click: this.onCellClick
      }
    }, [this.selectedItems.length > 0 ? this.selectedItems.map((s) => a("span", {
      class: this.ns.e("code-list-item"),
      style: s.colorStyle
    }, [s.text])) : a("span", {
      class: this.ns.e("text")
    }, [t])]);
  }
});
class Ie extends me {
  constructor() {
    super(...arguments);
    /**
     * 流程图url
     *
     * @type {string}
     * @memberof PresetWFChartViewController
     */
    T(this, "imgSrc");
  }
  async getUIData() {
    const s = Object.assign(this.context.clone(), this.params), o = await this.entityService.wf.getWFProcessDiagram(s), i = new Blob([o.data]);
    this.imgSrc = URL.createObjectURL(i);
  }
}
const Le = U({
  name: "PresetWFChartView",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const t = E("preset-wf-chart-view"), {
      proxy: s
    } = B(), o = X(s, (i, n) => new Ie(e.modelPath, i, n));
    return J(s, "deName", o.setDeName.bind(o)), {
      c: o,
      ns: t
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("img", {
      attrs: {
        src: this.c.imgSrc
      }
    })]);
  }
});
const Ne = U({
  name: "WFToolbar",
  props: {
    wfLinks: {
      type: Array,
      required: !0
    }
  },
  setup(e, {
    emit: t
  }) {
    return {
      ns: E("wf-toolbar"),
      handleClick: async (i, n) => {
        t("wf-link-click", i, n);
      }
    };
  },
  render() {
    const e = this.wfLinks || [];
    return a("div", {
      class: `${this.ns.b()}`
    }, [e.length > 0 && e.map((t) => {
      const s = t.sequenceFlowName == "驳回" || t.sequenceFlowName == "取消";
      return a("div", {
        key: t.sequenceFlowId,
        class: [this.ns.e("item"), s ? this.ns.em("item", "reject") : ""]
      }, [a("i-button", {
        attrs: {
          title: t.sequenceFlowName
        },
        on: {
          click: (o) => this.handleClick(t, o)
        }
      }, [t.sequenceFlowName || ""])]);
    })]);
  }
}), De = typeof btoa == "function", $ = typeof Buffer == "function";
typeof TextDecoder == "function" && new TextDecoder();
const z = typeof TextEncoder == "function" ? new TextEncoder() : void 0, Ae = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", I = Array.prototype.slice.call(Ae);
((e) => {
  let t = {};
  return e.forEach((s, o) => t[s] = o), t;
})(I);
const k = String.fromCharCode.bind(String);
typeof Uint8Array.from == "function" && Uint8Array.from.bind(Uint8Array);
const Me = (e) => e.replace(/=/g, "").replace(/[+\/]/g, (t) => t == "+" ? "-" : "_"), Be = (e) => {
  let t, s, o, i, n = "";
  const l = e.length % 3;
  for (let c = 0; c < e.length; ) {
    if ((s = e.charCodeAt(c++)) > 255 || (o = e.charCodeAt(c++)) > 255 || (i = e.charCodeAt(c++)) > 255)
      throw new TypeError("invalid character found");
    t = s << 16 | o << 8 | i, n += I[t >> 18 & 63] + I[t >> 12 & 63] + I[t >> 6 & 63] + I[t & 63];
  }
  return l ? n.slice(0, l - 3) + "===".substring(l) : n;
}, Z = De ? (e) => btoa(e) : $ ? (e) => Buffer.from(e, "binary").toString("base64") : Be, Oe = $ ? (e) => Buffer.from(e).toString("base64") : (e) => {
  let s = [];
  for (let o = 0, i = e.length; o < i; o += 4096)
    s.push(k.apply(null, e.subarray(o, o + 4096)));
  return Z(s.join(""));
}, Ge = (e) => {
  if (e.length < 2) {
    var t = e.charCodeAt(0);
    return t < 128 ? e : t < 2048 ? k(192 | t >>> 6) + k(128 | t & 63) : k(224 | t >>> 12 & 15) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  } else {
    var t = 65536 + (e.charCodeAt(0) - 55296) * 1024 + (e.charCodeAt(1) - 56320);
    return k(240 | t >>> 18 & 7) + k(128 | t >>> 12 & 63) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  }
}, Re = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, _e = (e) => e.replace(Re, Ge), V = $ ? (e) => Buffer.from(e, "utf8").toString("base64") : z ? (e) => Oe(z.encode(e)) : (e) => Z(_e(e)), ee = (e, t = !1) => t ? Me(V(e)) : V(e);
function $e(e, t, s) {
  var P;
  const o = b([]), i = b({
    Authorization: `Bearer ${Se("access_token")}`
  }), n = b(""), l = b(""), c = {
    count: 0,
    cacheFiles: []
    // iview上传过程中不能改default-file-list,所以需要缓存
  }, u = (P = s.editorParams) == null ? void 0 : P.blackList;
  let p = [];
  u && typeof u == "string" && (p = u.split(",")), S(
    () => e.value,
    (r) => {
      o.value = r ? JSON.parse(r) : [];
    },
    { immediate: !0 }
  ), S(
    () => e.data,
    (r) => {
      if (r) {
        const d = s.calcBaseUrl(r);
        n.value = d.uploadUrl, l.value = d.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), S(
    o,
    (r) => {
      r != null && r.length && l.value && r.forEach((d) => {
        d.url = d.url || l.value.replace("%fileId%", d.id);
      });
    },
    { immediate: !0 }
  ), S(
    l,
    (r) => {
      r && o.value.length && o.value.forEach((d) => {
        d.url = l.value.replace("%fileId%", d.id);
      });
    },
    { immediate: !0 }
  );
  const h = () => {
    const r = [...o.value, ...c.cacheFiles], d = r.length > 0 ? JSON.stringify(r.map((v) => ({ name: v.name, id: v.id }))) : null;
    c.cacheFiles = [], t(d);
  }, f = (r) => {
    const d = r.name.trim().toLowerCase();
    if (p.some((g) => d.endsWith(`.${g}`)))
      return ibiz.message.error(`不可上传 ${p.join("、")}类型的文件！`), !1;
    c.count += 1;
  }, F = (r) => {
    r && (c.cacheFiles.push({
      name: r.filename,
      id: r.fileid
    }), c.count -= 1, c.count === 0 && h());
  }, C = (r, d) => {
    throw c.count -= 1, new Y({
      response: { data: d, status: r.status }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    });
  }, x = (r) => {
    if (e.disabled)
      return;
    const d = o.value.findIndex((v) => v.id === r.id);
    d !== -1 && o.value.splice(d, 1), h();
  }, y = (r) => {
    const d = r.url || l.value.replace("%fileId%", r.id);
    s.fileDownload({ url: d, name: r.name });
  }, m = b(!1), w = b(""), N = b("");
  return {
    uploadUrl: n,
    downloadUrl: l,
    headers: i,
    files: o,
    onDownload: y,
    onError: C,
    onRemove: x,
    onSuccess: F,
    beforeUpload: f,
    showModal: m,
    modalTitle: w,
    iframeUrl: N,
    onModalCancel: () => {
      m.value = !1, w.value = "", N.value = "";
    },
    previewFile: (r) => {
      m.value = !0, w.value = r.name;
      const d = window.Environment.previewFileUrl;
      if (d) {
        const v = encodeURIComponent(
          ee(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        N.value = `${d}/onlinePreview?url=${v}`;
      }
    }
  };
}
const We = U({
  name: "SyFileUpload",
  props: he(),
  emits: K(),
  setup(e, {
    emit: t
  }) {
    const s = E("sy-file-upload"), o = e.controller, {
      uploadUrl: i,
      headers: n,
      files: l,
      onDownload: c,
      onError: u,
      onRemove: p,
      onSuccess: h,
      beforeUpload: f,
      showModal: F,
      modalTitle: C,
      iframeUrl: x,
      onModalCancel: y,
      previewFile: m
    } = $e(e, (w) => {
      t("change", w);
    }, o);
    return {
      ns: s,
      c: o,
      uploadUrl: i,
      headers: n,
      files: l,
      onDownload: c,
      onError: u,
      onRemove: p,
      onSuccess: h,
      beforeUpload: f,
      showModal: F,
      modalTitle: C,
      iframeUrl: x,
      onModalCancel: y,
      previewFile: m
    };
  },
  render(e) {
    return e("div", {
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [e("IUpload", {
      ref: "fileUpload",
      props: {
        action: this.uploadUrl,
        headers: this.headers,
        disabled: this.disabled,
        "default-file-list": this.files,
        multiple: this.c.model.multiple,
        type: this.c.model.isDrag ? "drag" : "select",
        accept: this.c.model.accept,
        "before-upload": this.beforeUpload,
        "on-success": this.onSuccess,
        "on-error": this.onError,
        "on-remove": this.onRemove,
        "on-preview": this.onDownload,
        "show-upload-list": !1
      }
    }, [this.c.model.isDrag ? e("div", {
      class: this.ns.bm("box", "drag")
    }, [e("i-icon", {
      attrs: {
        type: "md-cloud-upload"
      }
    }), e("div", {
      class: this.ns.be("box", "title")
    }, [e("span", ["将文件拖到此处，或"]), e("span", ["点击上传"])])]) : e("i-button", {
      attrs: {
        icon: "ios-cloud-upload-outline"
      },
      class: this.ns.bm("box", "select")
    }, ["上传文件"])]), e("div", {
      class: this.ns.b("file-list")
    }, [this.files.map((t) => e("div", {
      class: this.ns.b("file-item"),
      key: t.id
    }, [e("div", {
      class: this.ns.b("file-item-right")
    }, [e("div", {
      class: this.ns.b("file-item-right-title"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [t.name]), e("div", {
      class: this.ns.b("file-item-right-action")
    }, [e("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.onDownload(t)
      }
    }), e("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(t)
      }
    }), this.disabled || this.readonly ? null : e("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.onRemove(t)
      }
    })])])]))]), e("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [e("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
});
function M(e, t) {
  if (e.url = t.replace("%fileId%", e.id), e.status || (e.status = "finished"), !e.fileName) {
    const s = e.name.lastIndexOf(".");
    e.fileName = e.name.substring(0, s), e.fileExt = e.name.substring(s), e.isImage = Ue(e.name);
  }
  return e;
}
function te(e) {
  const t = b(""), s = b(""), o = b([]);
  return S(
    e.data,
    (i) => {
      if (i) {
        const n = e.controller.value.calcBaseUrl(i);
        t.value = n.uploadUrl, s.value = n.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), S(
    e.value,
    (i) => {
      o.value = i ? JSON.parse(i) : [], o.value.length && s.value && o.value.forEach((n) => {
        M(n, s.value);
      });
    },
    { immediate: !0 }
  ), S(
    s,
    (i) => {
      i && o.value.length && o.value.forEach((n) => {
        M(n, i);
      });
    },
    { immediate: !0 }
  ), {
    downloadUrl: s,
    uploadUrl: t,
    valueList: o
  };
}
function se(e) {
  var O, P;
  const t = b("undo"), s = b([]), { downloadUrl: o, value: i, uploadUrl: n, controller: l } = e, c = (P = (O = l == null ? void 0 : l.value) == null ? void 0 : O.editorParams) == null ? void 0 : P.blackList;
  let u = [];
  c && typeof c == "string" && (u = c.split(",")), S(
    i,
    (r) => {
      r.length > 0 && (s.value = [], r.forEach((d) => {
        s.value.push(M(d, o.value));
      }));
    },
    {
      immediate: !0,
      deep: !0
    }
  );
  const p = (r, d) => {
    const v = [];
    return d.forEach((g, D) => {
      const A = g.name.trim().toLowerCase();
      if (u.some((ne) => A.endsWith(`.${ne}`))) {
        v.push(D);
        return;
      }
      s.value.push({
        name: g.name,
        status: g.status,
        percentage: g.percentage,
        id: g.uid,
        url: ""
      });
    }), v.length === d.length ? (ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`), !1) : (v.length && (v.forEach((g) => {
      r.splice(g, 1), d.splice(g, 1);
    }), ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`)), !0);
  }, h = (r) => {
    r.forEach((d) => {
      s.value.find((v) => v.id === d.uid ? (v.percentage = d.percentage, !0) : !1);
    });
  }, f = (r, d) => {
    r.forEach((v) => {
      s.value.find((g) => g.id === v.uid ? (g.status = v.status, g.id = d.data.fileid, g.name = d.data.filename, M(g, o.value), !0) : !1);
    });
  }, F = (r, d) => {
    var g;
    r.forEach((D) => {
      s.value.find((A) => A.id === D.uid ? (A.status = D.status, !0) : !1);
    });
    const v = new Y(d);
    ibiz.notification.error({
      title: (g = v.status) == null ? void 0 : g.toString(),
      desc: v.message,
      duration: 10
    });
  }, C = (r) => {
    s.value = s.value.filter((d) => d.status === "finished"), t.value = "done";
  }, x = () => {
    Ee({
      multiple: e.multiple,
      accept: e.accept,
      uploadUrl: n.value,
      beforeUpload: p,
      progress: h,
      success: f,
      error: F,
      finish: C
    });
  }, y = b(!1), m = b(""), w = b("");
  return {
    selectFile: x,
    fileList: s,
    uploadState: t,
    showModal: y,
    modalTitle: m,
    iframeUrl: w,
    onModalCancel: () => {
      y.value = !1, m.value = "", w.value = "";
    },
    previewFile: (r) => {
      y.value = !0, m.value = r.name;
      const d = window.Environment.previewFileUrl;
      if (d) {
        const v = encodeURIComponent(
          ee(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        w.value = `${d}/onlinePreview?url=${v}`;
      }
    }
  };
}
const ze = U({
  name: "SyGridFileUpload",
  props: R(),
  setup(e) {
    const t = E("sy-grid-file-upload"), {
      value: s,
      data: o,
      controller: i
    } = G(e), {
      downloadUrl: n,
      uploadUrl: l,
      valueList: c
    } = te({
      value: s,
      data: o,
      controller: i
    }), {
      fileList: u,
      showModal: p,
      modalTitle: h,
      iframeUrl: f,
      previewFile: F,
      onModalCancel: C
    } = se({
      downloadUrl: n,
      uploadUrl: l,
      value: c
    });
    return {
      ns: t,
      fileList: u,
      showModal: p,
      modalTitle: h,
      iframeUrl: f,
      downloadFile: (y) => {
        e.controller.fileDownload(y);
      },
      previewFile: F,
      onModalCancel: C
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.previewFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.downloadFile(e)
      }
    }), a("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(e)
      }
    })])]))]), a("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [a("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
}), Ve = U({
  name: "SyGridFileUploadContainer",
  props: R(),
  emits: _(),
  render(e) {
    return this.disabled || this.readonly ? e("SyGridFileUpload", {
      props: {
        ...this.$props
      }
    }) : e("SyEditGridFileUpload", {
      props: {
        ...this.$props
      },
      on: {
        change: (t, s) => {
          this.$emit("change", t, s);
        },
        rowSave: () => {
          this.$emit("rowSave");
        }
      }
    });
  }
});
const je = U({
  name: "SyEditGridFileUploadPopover",
  props: {
    uploadUrl: {
      type: String,
      required: !0
    },
    downloadUrl: {
      type: String,
      required: !0
    },
    value: {
      type: Array,
      required: !0
    },
    controller: {
      type: H,
      required: !0
    }
  },
  emits: {
    close: (e) => !0
  },
  setup(e, {
    emit: t
  }) {
    const s = E("sy-edit-grid-file-upload-popover"), {
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: l
    } = G(e), {
      fileList: c,
      uploadState: u,
      selectFile: p
    } = se({
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: l
    }), h = b(), f = b(!1), F = fe(h, async (y) => {
      t("close", {
        isModified: f.value,
        resultFiles: c.value
      });
    });
    return S(u, (y) => {
      y === "done" ? (f.value = !0, F.proceed()) : y === "loading" && F.pause();
    }), {
      ns: s,
      componentRef: h,
      fileList: c,
      deleteFile: (y) => {
        const m = c.value.findIndex((w) => w.id === y.id);
        c.value.splice(m, 1), f.value = !0;
      },
      selectFile: p,
      downloadFile: (y) => {
        e.controller.fileDownload(y);
      }
    };
  },
  render() {
    return a("div", {
      ref: "componentRef",
      style: "width:300px",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.downloadFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.deleteFile(e)
      }
    })])]))]), a("div", {
      on: {
        click: () => this.selectFile()
      },
      class: this.ns.e("button")
    }, [a("i-icon", {
      attrs: {
        type: "md-add"
      }
    }), "添加文件"])]);
  }
});
const qe = U({
  name: "SyEditGridFileUpload",
  props: R(),
  emits: _(),
  setup(e, {
    emit: t
  }) {
    const s = E("sy-edit-grid-file-upload"), {
      value: o,
      data: i,
      controller: n
    } = G(e), {
      downloadUrl: l,
      uploadUrl: c,
      valueList: u
    } = te({
      value: o,
      data: i,
      controller: n
    }), p = b(), h = async () => {
      if (!p.value)
        throw new xe("容器元素不存在");
      const f = p.value.$el, F = f.offsetHeight, C = ibiz.overlay.createPopover((m) => m(je, {
        props: {
          value: u.value,
          uploadUrl: c.value,
          downloadUrl: l.value,
          controller: n.value
        },
        on: {
          close: (w) => {
            C.dismiss(w);
          }
        }
      }), void 0, {
        noArrow: !0,
        placement: "bottom-start",
        offsetOpts: {
          mainAxis: -F,
          crossAxis: 0
        }
      });
      await C.present(f);
      const {
        isModified: x,
        resultFiles: y
      } = await C.onWillDismiss();
      if (x) {
        const m = y.length > 0 ? JSON.stringify(y.map((w) => ({
          name: w.name,
          id: w.id
        }))) : null;
        t("change", m), t("rowSave");
      }
    };
    return be(p, "click", (f) => {
      e.disabled || h();
    }), {
      ns: s,
      valueList: u,
      componentRef: p
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.valueList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title")
    }, [e.name])]))])]);
  }
});
U({
  name: "SyInput",
  props: ve(),
  emits: K(),
  setup(e, {
    emit: t
  }) {
    const s = E("input"), i = e.controller.model, n = b(), l = b(2);
    i.editorType === "TEXTAREA_10" && (l.value = 10);
    const c = L(() => {
      switch (i.editorType) {
        case "TEXTBOX":
          return "text";
        case "PASSWORD":
          return "password";
        case "TEXTAREA":
        case "TEXTAREA_10":
          return "textarea";
        default:
          return "string";
      }
    }), u = b("");
    S(() => e.value, (m, w) => {
      m !== w && (m ? u.value = m : u.value = "");
    }, {
      immediate: !0
    });
    let p = !1, h, f;
    const F = ke((m) => {
      f !== m.target.value && t("change", m.target.value), f = void 0, p = !1, h && h();
    }, 300, {
      leading: !0
    }), C = (m) => {
      p = !0, F(m);
    }, x = (m) => {
      m && m.code === "Enter" && p && (h = () => {
        n.value.$el.dispatchEvent(m);
      });
    }, y = () => {
      f = n.value.currentValue, t("change", f);
    };
    return e.autoFocus && S(n, (m) => {
      m && m.$el.getElementsByTagName("input")[0].focus();
    }), {
      ns: s,
      rows: l,
      type: c,
      currentVal: u,
      handleChange: C,
      handleKeyUp: x,
      handleBlur: y,
      inputRef: n
    };
  },
  render() {
    return a("div", {
      class: [this.ns.b(), this.ns.b("sy-input"), this.ns.is("textarea", Object.is(this.type, "textarea")), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [this.readonly ? this.currentVal : a("i-input", {
      ref: "inputRef",
      attrs: {
        value: this.currentVal,
        placeholder: this.controller.placeHolder,
        type: this.type,
        rows: this.rows,
        disabled: this.disabled,
        autosize: Object.is(this.type, "textarea")
      },
      on: {
        "on-change": this.handleChange,
        "on-blur": this.handleBlur
      },
      nativeOn: {
        keyup: this.handleKeyUp
      },
      class: this.ns.b("input")
    }, [this.controller.model.unitName && a("i", {
      class: this.ns.e("unit"),
      slot: "suffix"
    }, [this.controller.model.unitName])])]);
  }
});
U({
  name: "SyGridInput",
  props: ye(),
  emits: _(),
  setup(e, {
    emit: t
  }) {
    const s = E("grid-input"), {
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: l,
      onChange: c
    } = we(e, {
      emit: t
    });
    return {
      ns: s,
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: l,
      onChange: c
    };
  },
  render(e) {
    return e("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: `${this.ns.b()}`
    }, [e("SyInput", {
      props: {
        ...this.$props,
        readonly: this.isInfoMode,
        disabled: this.disabled,
        autoFocus: this.autoFocus
      },
      on: {
        change: this.onChange,
        operate: this.onOperateChange
      }
    })]);
  }
});
function j(e, t) {
  return a("div", {
    class: e.e("logo")
  }, [t.appIconPath ? a("img", {
    class: e.e("logo-img"),
    attrs: {
      src: t.appIconPath
    }
  }) : null, a("div", {
    class: e.e("logo-caption")
  }, [t.caption])]);
}
const He = U({
  name: "UserAppLayout",
  props: {
    model: {
      type: le,
      required: !0
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: !1
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: !1
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = E("layout"), o = b(!1), i = () => {
      o.value = !o.value, t("onCollapseChange", o.value);
    }, n = L(() => e.model.source.blankMode === !0), l = L(() => !!(window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl));
    return {
      ns: s,
      collapseChange: o,
      isBlank: n,
      collapseMenus: i,
      isShowDownload: l,
      downloadUserBook: () => {
        const u = window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl;
        u ? window.open(u) : console.log("环境变量里没有manualdownloadurl");
      }
    };
  },
  render() {
    return this.isComplete ? a("i-layout", {
      class: [this.ns.b(), this.isBlank ? this.ns.m("blank") : "", this.ns.is("collapse", this.collapseChange), this.ns.is("tab", this.isShowTabPageExp), "user-layout"]
    }, [a("i-sider", {
      attrs: {
        "hide-trigger": !0,
        value: this.collapseChange
      },
      class: [this.ns.b("nav"), this.ns.is("collapse", this.collapseChange)]
    }, [j(this.ns, this.model), this.$slots.menu]), a("i-layout", {
      class: [this.ns.b("content")]
    }, [a("i-header", {
      class: this.ns.b("header")
    }, [a("div", {
      class: this.ns.be("header", "left")
    }, [j(this.ns, this.model), a("div", {
      class: this.ns.be("header", "collapse-icon")
    }, [this.collapseChange ? a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-unfold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    }) : a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-fold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    })]), this.model.source.mainMenuAlign === "TOP" ? a("i-menu", {
      class: this.ns.be("header", "menu"),
      attrs: {
        mode: "horizontal",
        "active-name": "1"
      }
    }) : null]), a("div", {
      class: this.ns.be("header", "right")
    }, [this.isShowDownload && a("div", {
      class: "user-download",
      on: {
        click: () => this.downloadUserBook()
      }
    }, ["用户手册下载"]), a("app-user")])]), a("i-content", {
      class: this.ns.be("content", "main")
    }, [this.$slots.tabPageExp, this.$slots.default])])]) : null;
  }
});
class Xe {
  constructor() {
    T(this, "component", Le);
  }
}
class Je {
  constructor() {
    T(this, "component", Pe);
  }
  async createController(t, s) {
    const o = new q(t, s);
    return await o.init(), o;
  }
}
class Ke {
  constructor() {
    T(this, "component", "IndexView");
  }
}
const oe = U({
  name: "WFStepTraceGrid",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const {
      proxy: t
    } = B(), s = ge(t, e.modelPath);
    J(t, "deName", s.setDeName.bind(s));
    const o = E("wf-step-trace-grid"), i = b([]), n = (c, u, p = !1) => {
      c.identitylinks.length > 0 || c.comments.length > 0 && c.comments.forEach((h) => {
        p && h.type === "启动流程" || u.push({
          id: W(),
          nodeName: c.userTaskName,
          personName: h.authorName,
          time: h.time,
          content: h.type,
          comment: h.fullMessage
        });
      });
    };
    s.nerve.self.evt.on("mounted", () => {
      var c;
      s.data && ((c = s.data.usertasks) == null || c.forEach((u) => {
        if (u.usertasks && u.usertasks.length > 0) {
          const p = [];
          u.usertasks.forEach((h) => {
            n(h, p, !0);
          }), i.value.push({
            id: W(),
            nodeName: `${u.userTaskName}`,
            personName: "",
            time: "",
            content: "",
            comment: "",
            children: p,
            _showChildren: !0
          });
        } else
          n(u, i.value);
      }), i.value.sort((u, p) => Date.parse(u.time) - Date.parse(p.time)), console.log(1, i.value), console.log(2, s.data));
    });
    const l = b([{
      title: "处理环节",
      key: "nodeName",
      width: 180,
      resizable: !0,
      tree: !0
    }, {
      title: "处理人",
      key: "personName",
      width: 180,
      resizable: !0
    }, {
      title: "处理时间",
      key: "time",
      width: 180,
      resizable: !0
    }, {
      title: "处理内容",
      key: "content",
      width: 180,
      resizable: !0
    }, {
      title: "处理意见",
      key: "comment"
    }]);
    return {
      c: s,
      ns: o,
      gridData: i,
      columns: l
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.e("title")
    }, ["审批信息"]), a("i-table", {
      attrs: {
        "disabled-hover": !0,
        columns: this.columns,
        data: this.gridData,
        "row-key": "id"
      },
      class: this.ns.e("grid")
    })]);
  }
});
class Ye extends pe {
  async calcWfToolbar() {
    await super.calcWfToolbar(), this.isEditable && this.wfLinks.unshift({
      sequenceFlowName: "保存",
      type: "FORM_SAVE"
    });
  }
  async onLinkClick(t) {
    t.type === "FORM_SAVE" ? await this.save() : super.onLinkClick(t);
  }
}
U({
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = B(), s = X(t, (l, c) => new Ye(e.modelPath, l, c)), o = E(`view-${ce.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase()), i = b(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (l) => {
        i.value.includes(l) || i.value.push(l);
      },
      lazyList: i
    };
  },
  render(e) {
    const t = [];
    if (this.c.complete) {
      const {
        activeForm: s
      } = this.c;
      s && this.c.providers[s.name] && t.push(e(this.c.providers[s.name].component, {
        props: {
          modelData: s,
          context: this.c.context,
          params: this.c.params
        },
        style: {
          height: "auto"
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit("form")
        }
      }));
    }
    if (this.c.complete && this.c.model.drTab.pages[0]) {
      const s = this.c.model.drTab.pages[0], o = this.c.drPages[s.source.name];
      t.push(e(oe, {
        attrs: {
          context: o.context,
          params: o.params,
          deName: this.c.model.appEntity.source.codeName,
          modal: this.modal,
          modelPath: s.embedView.source.modelPath
        }
      }));
    }
    return e("view-base", {
      attrs: {
        controller: this.c
      },
      scopedSlots: {
        toolbar: () => this.c.complete ? [this.c.wfLinks.length > 0 && e("wf-toolbar", {
          attrs: {
            wfLinks: this.c.wfLinks
          },
          on: {
            "wf-link-click": (s) => {
              this.c.onLinkClick(s);
            }
          }
        })] : null
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [t]), this.c.model.drTab.pages.map((s) => {
      const o = this.c.drPages[s.source.name];
      return e("i-tab-pane", {
        class: this.ns.be("", "tab-item"),
        attrs: {
          tab: this.c.model.drTab.source.name,
          disabled: this.c.isNewData,
          label: s.source.caption,
          name: s.source.name
        }
      }, [!this.c.isNewData && this.lazyList.includes(s.source.name) && e("ViewShell", {
        attrs: {
          context: o.context,
          params: o.params,
          modal: {
            mode: Q.EMBED
          },
          modelPath: s.embedView.source.modelPath,
          // 流程跟踪视图用
          deName: this.c.model.appEntity.source.codeName
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit(s.source.name)
        },
        key: o.key
      })]);
    })])]);
  }
});
U({
  name: "SyEditView3",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = B(), s = Fe(t, e.modelPath), o = E("view-deeditview3"), i = b(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (l) => {
        i.value.includes(l) || i.value.push(l);
      },
      lazyList: i
    };
  },
  render(e) {
    return e("view-base", {
      attrs: {
        controller: this.c
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [e("edit-form-control", {
      attrs: {
        modelData: this.c.model.form,
        context: this.c.context,
        params: this.c.params
      },
      style: {
        height: "auto"
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit(this.c.model.form.source.name)
      }
    }), e(oe, {
      attrs: {
        context: this.c.drPages[this.c.model.drTab.pages[0].source.name].context,
        params: this.c.drPages[this.c.model.drTab.pages[0].source.name].params,
        deName: this.c.model.appEntity.source.codeName,
        modal: this.modal,
        modelPath: this.c.model.drTab.pages[0].embedView.source.modelPath
      }
    })]), this.c.model.drTab.pages.map((t) => {
      const s = this.c.drPages[t.source.name];
      if (s)
        return e("i-tab-pane", {
          class: this.ns.be("", "tab-item"),
          attrs: {
            tab: this.c.model.drTab.source.name,
            disabled: this.c.isNewData,
            label: t.source.caption,
            name: t.source.name
          }
        }, [!this.c.isNewData && this.lazyList.includes(t.source.name) && e("ViewShell", {
          attrs: {
            context: s.context,
            params: s.params,
            modal: {
              mode: Q.EMBED
            },
            modelPath: t.embedView.source.modelPath,
            // 流程跟踪视图用
            deName: this.c.model.appEntity.source.codeName
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(t.source.name)
          },
          key: s.key
        })]);
    })])]);
  }
});
class Qe {
  constructor() {
    T(this, "formEditor", "SyFileUpload");
    T(this, "gridEditor", "SyGridFileUploadContainer");
  }
  async createController(t, s) {
    const o = new H(t, s);
    return await o.init(), o;
  }
}
const Ze = new Te(import.meta.url), dt = {
  mateUrl: import.meta.url,
  install(e) {
    de.getModelService().then((t) => {
      t.app.userParams.autoWidth === "true" && document.getElementsByClassName("app")[0].classList.add("auto-width");
    }), Ze.loadStyle(["/style.css"]), ibiz.config.enableDataInfoBar = !1, ibiz.config.gridEditShowMode = "all", e.component("WfToolbar", Ne), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWebIndexView",
      new Ke()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_PresetWFChartView",
      new Xe()
    ), ibiz.register.gridColumn.register(
      "GRID_COLRENDER_CodeListGridColumn",
      new Je()
    ), e.component("SyFileUpload", We), e.component("SyGridFileUpload", ze), e.component("SyEditGridFileUpload", qe), e.component("SyGridFileUploadContainer", Ve), ibiz.register.editor.register(
      "EDITOR_CUSTOMSTYLE_SyFileUpload",
      new Qe()
    ), e.component("AppLayout", He);
  }
};
export {
  dt as default
};
