import { ViewEngine } from "./view-engine";

/**
 * 实体面板视图引擎
 *
 * @export
 * @class PanelViewEngine
 * @extends {ViewEngine}
 */
export class PanelViewEngine extends ViewEngine {

  /**
   * 面板部件
   *
   * @protected
   * @type {*}
   * @memberof PanelViewEngine
   */
  protected panel: any = null;

  /**
   * 引擎初始化
   *
   * @param {*} options
   * @memberof PanelViewEngine
   */
  public init(options: any) {
    this.panel = options.panel;
    super.init(options);
  }

  /**
   * 引擎加载
   *
   * @memberof PanelViewEngine
   */
  public load(data: any = {}) {
    const panel = this.getPanel();
    if (panel && this.isLoadDefault) {
      this.setViewState2({ tag: panel.name, action: 'load', viewdata: data });
    }
    this.isLoadDefault = false;
  }

  /**
   * 刷新
   *
   * @param {*} [args]
   * @memberof PanelViewEngine
   */
  public refresh(args?: any) {
    const panel = this.getPanel();
    if (panel) {
      this.setViewState2({ tag: panel.name, action: 'refresh', viewdata: args });
    }
  }

  /**
   * 获取面板部件
   *
   * @return {*}  {*}
   * @memberof PanelViewEngine
   */
  public getPanel(): any {
    return this.panel;
  }

    /**
     * @description 视图销毁
     * @memberof PanelViewEngine
     */
    public destroyed() {
        super.destroyed();
        this.panel = null;
    }
}