import { VueConstructor } from 'vue';
import { install as installCore } from '@ibiz-template/core';
import { install as installModel } from '@ibiz-template/model';
import { install as installService } from '@ibiz-template/service';
import { install as installRuntime } from '@ibiz-template/runtime';
import { install as installController } from '@ibiz-template/controller';
import { IViewRegister } from './i-view-register';
import {
  AppLayout,
  ControlLayout,
  MDViewBase,
  ViewBase,
  ViewLayout,
} from './components/layout';
import {
  AppMenu,
  EditFormControl,
  FormControl,
  FormPage,
  FormPageItem,
  FormGroupPanel,
  FormItemContainer,
  FormItem,
  GridControl,
  SearchFormControl,
  FormTabPanel,
  FormTabPage,
  FormRawItem,
  FormButton,
  FormDRUIPart,
  GridFieldEditColumn,
  GridUAColumn,
  GridFieldColumn,
  ViewPanel,
  PickupViewPanel,
  DashboardControl,
  PortletContainer,
  PortletPart,
  ListControl,
  ListPortlet,
} from './components/widgets';
import {
  EditView,
  GridView,
  PickupGridView,
  PickupView,
  MPickupView,
  OptView,
  EditView3,
  WFDynaActionView,
  WFDynaEditView3,
  WFDynaStartView,
  WFStepTraceView,
  AppPortalView,
} from './components/views';
import { IndexView } from './views';
import AppKeepAlive from './components/common/app-keep-alive/app-keep-alive.vue';
import { presetAllProviders } from './provider';
import { ViewShell } from './components/view-shell/view-shell';
import {
  AppIcon,
  ViewToolbar,
  WFToolbar,
  QuickSearch,
  AppCol,
  AppRow,
  AppGridPagination,
  AppGridEditItem,
  ActionToolbar,
  AppUser,
  AppTransition,
  WfVersionSelect,
  ExtendActionTimeLine,
  ExtendActionGrid,
  AppSelectTree,
  DataImport,
  DataExport,
} from './components/common';
// 编辑器组件
import {
  IBizGridFileUpload,
  IBizImageUpload,
  IBizInputNumber,
  IBizPickerLink,
  IBizCheckbox,
  IBizDatePicker,
  IBizDropdown,
  IBizFileUpload,
  IBizInput,
  IBizMPicker,
  IBizPicker,
  IBizPickerDropDown,
  IBizRadio,
  IBizSpan,
  NotSupportedEditor,
  IBizGridInput,
  IBizGridCheckbox,
  IBizGridInputNumber,
  IBizGridSpan,
  IBizGridDatePicker,
  IBizGridDropdown,
  IBizGridRadio,
  IBizGridPicker,
} from './components/editor';

export const AppRegister = {
  install(v: VueConstructor) {
    installCore();
    installModel();
    installService();
    installRuntime();
    installController();
    presetAllProviders();
    v.use(IViewRegister);
    // 注册布局组件
    v.component('AppLayout', AppLayout);
    v.component('ControlLayout', ControlLayout);
    v.component('ViewLayout', ViewLayout);
    v.component('ViewBase', ViewBase);
    v.component('MdViewBase', MDViewBase);
    v.component('ViewShell', ViewShell);
    // 注册视图组件
    v.component('IndexView', IndexView);
    v.component('GridView', GridView);
    v.component('EditView', EditView);
    v.component('EditView3', EditView3);
    v.component('OptView', OptView);
    v.component('PickupGridView', PickupGridView);
    v.component('PickupView', PickupView);
    v.component('MPickupView', MPickupView);
    v.component('WFDynaActionView', WFDynaActionView);
    v.component('WFDynaStartView', WFDynaStartView);
    v.component('WFDynaEditView3', WFDynaEditView3);
    v.component('WFStepTraceView', WFStepTraceView);
    v.component('AppPortalView', AppPortalView);
    // 注册部件组件
    v.component('AppMenu', AppMenu);
    v.component('GridControl', GridControl);
    v.component('ListControl', ListControl);
    v.component('GridUAColumn', GridUAColumn);
    v.component('GridFieldColumn', GridFieldColumn);
    v.component('GridFieldEditColumn', GridFieldEditColumn);
    v.component('FormButton', FormButton);
    v.component('FormDruipart', FormDRUIPart);
    v.component('FormGroupPanel', FormGroupPanel);
    v.component('FormItem', FormItem);
    v.component('FormPage', FormPage);
    v.component('FormPageItem', FormPageItem);
    v.component('FormRawItem', FormRawItem);
    v.component('FormTabPage', FormTabPage);
    v.component('FormTabPanel', FormTabPanel);
    v.component('FormControl', FormControl);
    v.component('EditFormControl', EditFormControl);
    v.component('SearchFormControl', SearchFormControl);
    v.component('ViewPanel', ViewPanel);
    v.component('PickupViewPanel', PickupViewPanel);
    v.component('DashboardControl', DashboardControl);
    v.component('PortletPart', PortletPart);
    v.component('ListPortlet', ListPortlet);
    v.component('PortletContainer', PortletContainer);
    // 注册通用组件
    v.component('AppKeepAlive', AppKeepAlive);
    v.component('AppIcon', AppIcon);
    v.component('AppCol', AppCol);
    v.component('AppRow', AppRow);
    v.component('ViewToolbar', ViewToolbar);
    v.component('WfToolbar', WFToolbar);
    v.component('ActionToolbar', ActionToolbar);
    v.component('AppGridPagination', AppGridPagination);
    v.component('FormItemContainer', FormItemContainer);
    v.component('AppGridEditItem', AppGridEditItem);
    v.component('AppUser', AppUser);
    v.component('AppTransition', AppTransition);
    v.component('WfVersionSelect', WfVersionSelect);
    v.component('ExtendActionTimeLine', ExtendActionTimeLine);
    v.component('ExtendActionGrid', ExtendActionGrid);
    v.component('AppSelectTree', AppSelectTree);
    v.component('DataImport', DataImport);
    v.component('DataExport', DataExport);
    // 注册编辑器组件
    v.component('IBizSpan', IBizSpan);
    v.component('IBizInput', IBizInput);
    v.component('IBizInputNumber', IBizInputNumber);
    v.component('IBizCheckbox', IBizCheckbox);
    v.component('IBizRadio', IBizRadio);
    v.component('IBizDatePicker', IBizDatePicker);
    v.component('IBizDropdown', IBizDropdown);
    v.component('IBizPicker', IBizPicker);
    v.component('IBizPickerDropDown', IBizPickerDropDown);
    v.component('IBizPickerLink', IBizPickerLink);
    v.component('IBizMPicker', IBizMPicker);
    v.component('IBizFileUpload', IBizFileUpload);
    v.component('IBizGridFileUpload', IBizGridFileUpload);
    v.component('IBizImageUpload', IBizImageUpload);
    v.component('QuickSearch', QuickSearch);
    v.component('NotSupportedEditor', NotSupportedEditor);
    // 注册表格编辑器
    v.component('IBizGridInput', IBizGridInput);
    v.component('IBizGridSpan', IBizGridSpan);
    v.component('IBizGridInputNumber', IBizGridInputNumber);
    v.component('IBizGridCheckbox', IBizGridCheckbox);
    v.component('IBizGridDatePicker', IBizGridDatePicker);
    v.component('IBizGridDropdown', IBizGridDropdown);
    v.component('IBizGridRadio', IBizGridRadio);
    v.component('IBizGridPicker', IBizGridPicker);
  },
};
