import { ActionBarPortletProvider } from './action-bar-portlet-provider';
import { AppMenuPortletProvider } from './app-menu-portlet-provider';
import { ChartPortletProvider } from './chart-portlet-provider';
import { ContainerPortletProvider } from './container-portlet-provider';
import { CustomPortletProvider } from './custom-portlet-provider';
import { HtmlPortletProvider } from './html-portlet-provider';
import { ListPortletProvider } from './list-portlet-provider';
import { RawItemPortletProvider } from './raw-item-portlet-provider';
import { ToolbarPortletProvider } from './toolbar-portlet-provider';
import { ViewPortletProvider } from './view-portlet-provider';

/**
 * 预置默认的表单成员适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:50
 * @export
 */
export function presetPortletPartProvider(): void {
  const { portletPart } = ibiz.register;
  if (!portletPart) {
    return;
  }
  // 实体列表
  portletPart.register('LIST', new ListPortletProvider());
  // 实体图表
  portletPart.register('CHART', new ChartPortletProvider());
  // 系统视图
  portletPart.register('VIEW', new ViewPortletProvider());
  // 网页部件
  portletPart.register('HTML', new HtmlPortletProvider());
  // 工具栏
  portletPart.register('TOOLBAR', new ToolbarPortletProvider());
  // 操作栏
  portletPart.register('ACTIONBAR', new ActionBarPortletProvider());
  // 自定义
  portletPart.register('CUSTOM', new CustomPortletProvider());
  // 快捷菜单
  portletPart.register('APPMENU', new AppMenuPortletProvider());
  // 直接内容
  portletPart.register('RAWITEM', new RawItemPortletProvider());
  // 布局容器
  portletPart.register('CONTAINER', new ContainerPortletProvider());
}

export {
  ActionBarPortletProvider,
  AppMenuPortletProvider,
  ChartPortletProvider,
  ContainerPortletProvider,
  CustomPortletProvider,
  HtmlPortletProvider,
  ListPortletProvider,
  RawItemPortletProvider,
  ToolbarPortletProvider,
  ViewPortletProvider,
};
