import { FormTabPanelModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormTabPanelController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单分页部件适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormTabPanelProvider
 * @implements {EditorProvider}
 */
export class FormTabPanelProvider implements IFormDetailProvider {
  compName: string = 'FormTabPanel';

  async createController(
    detailModel: FormTabPanelModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormTabPanelController> {
    const c = new FormTabPanelController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
