import { defineComponent } from 'vue';
import {
  getGridInputNumberProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridInputNumber = defineComponent({
  name: 'IBizGridInputNumber',
  props: getGridInputNumberProps(),
  setup(props) {
    const ns = useNamespace('grid-input-number');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: true,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <div
        ref='componentRef'
        class={`${this.ns.b()} ibiz-grid-editor`}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {h('IBizInputNumber', {
          props: {
            ...this.$props,
            infoMode: this.isInfoMode,
            autoFocus: true,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </div>
    );
  },
});
