import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import { IViewMessage } from '@ibiz-template/controller';

export const ViewMessage = defineComponent({
  name: 'ViewMessage',
  props: {
    messages: {
      type: Array<IViewMessage>,
    },
  },
  setup() {
    const ns = useNamespace('view-message');

    const getType = (messageType?: string): string => {
      switch (messageType) {
        case 'WARN':
          return 'warning';
        case 'ERROR':
          return 'error';
        default:
          return 'info';
      }
    };

    return { ns, getType };
  },
  render() {
    if (!this.messages?.length) {
      return null;
    }
    return (
      <div class={[this.ns.b()]}>
        {this.messages?.map(message => {
          return (
            <i-alert
              type={this.getType(message.messageType)}
              closable={message.removeMode !== 0}
            >
              {message.title}
              {message.message && (
                <template slot='desc'>{message.message}</template>
              )}
            </i-alert>
          );
        })}
      </div>
    );
  },
});
