import { EditorModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/editor/not-supported-editor/not-supported-editor.scss';

export const NotSupportedEditor = defineComponent({
  name: 'NotSupportedEditor',
  props: {
    modelData: {
      type: EditorModel,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('not-supported-editor');
    return { ns };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        未支持的编辑器类型 - {this.modelData.editorType}
      </div>
    );
  },
});
