var P = Object.defineProperty;
var F = (h, u, e) => u in h ? P(h, u, { enumerable: !0, configurable: !0, writable: !0, value: e }) : h[u] = e;
var L = (h, u, e) => (F(h, typeof u != "symbol" ? u + "" : u, e), e);
import { useControlController as T } from "@ibiz-template/vue-util";
import { Neuron as I, ControlNerve as N, ControlController as z } from "@ibiz-template/controller";
import { createUUID as M } from "qx-util";
import { init as D } from "echarts";
import { mergeDeepRight as y } from "ramda";
import { ControlService as j } from "@ibiz-template/service";
class $ extends I {
}
class H extends N {
  createNeuron() {
    return new $(this.bindAbility());
  }
  bindAbility() {
    return {
      ...super.bindAbility(),
      load: this.controller.load.bind(this.controller)
    };
  }
}
function S(h) {
  const u = {};
  return h && Object.keys(h).forEach((e) => {
    const s = e.indexOf(".");
    if (s === -1)
      return;
    const r = e.slice(s + 1);
    if (r && h[e] !== void 0)
      try {
        u[r] = JSON.parse(h[e]);
      } catch (o) {
        ibiz.log.error(`${r} 解析错误`);
      }
  }), u;
}
function k(h) {
  var e;
  const u = {};
  if (h) {
    u.show = h.showTitle, u.text = h.title, u.subtext = h.subTitle;
    const s = (e = h.titlePos) == null ? void 0 : e.toLowerCase();
    s === "left" || s === "right" ? u.left = s : (s === "bottom" || s === "top") && (u.left = "center", u.top = s);
  }
  return u;
}
function q(h) {
  var e;
  const u = {};
  if (h) {
    u.show = h.showLegend;
    const s = (e = h.legendPos) == null ? void 0 : e.toLowerCase();
    s === "left" || s === "right" ? (u.left = s, u.top = "middle", u.orient = "vertical") : s === "bottom" && (u.top = s);
  }
  return u;
}
function v(h) {
  return {
    axisLabel: {
      formatter: (e) => h === 1 ? e.length > 4 ? `${e.slice(0, 4).split("").join(`
`)}
...` : e.split("").join(`
`) : h === 2 && e.length > 4 ? `${e.slice(0, 4)}...` : e,
      rotate: h === 2 ? 45 : 0
    }
  };
}
function R(h) {
  const u = [];
  return h && h.length && h.forEach((e) => {
    const { caption: s, minValue: r, maxValue: o, eChartsType: t, position: i } = e, n = {
      name: s,
      min: r,
      max: o
    };
    Object.assign(n, {
      type: t,
      position: i,
      ...y(
        v(e.dataShowMode),
        S(e.userParams)
      )
    }), u.push(n);
  }), u;
}
function V(h) {
  const u = [];
  return h && h.length && h.forEach((e) => {
    const { caption: s, minValue: r, maxValue: o, eChartsType: t, position: i } = e, n = {
      name: s,
      min: r,
      max: o
    };
    Object.assign(n, {
      type: t,
      position: i,
      ...y(
        v(e.dataShowMode),
        S(e.userParams)
      )
    }), u.push(n);
  }), u;
}
class B extends j {
  constructor(e) {
    super(e);
    /**
     * 序列列表
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:38
     * @type {IPSDEChartSeries[]}
     */
    L(this, "seriesList", []);
    const s = e.source.getPSDEChartSerieses();
    if (!s || !s.length)
      throw new Error("图表序列集合不能为空");
    this.seriesList = s;
  }
  /**
   * 获取数据
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:11
   * @param {IContext} context
   * @param {IParams} [params={}]
   * @return {*}  {Promise<IHttpResponse>}
   */
  async fetch(e, s = {}) {
    return await this.exec(this.model.fetchAction, e, s);
  }
  /**
   * 获取所有代码表映射
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:21
   * @param {IContext} context
   * @param {IParams} params
   * @return {*}
   */
  async getAllCodeListMap(e, s) {
    const r = [];
    return await Promise.all(
      this.seriesList.map(async (o, t) => {
        var a, c, d, g;
        const i = {}, n = (c = (a = o.getCatalogPSCodeList) == null ? void 0 : a.call(o)) == null ? void 0 : c.codeName, m = (g = (d = o.getSeriesPSCodeList) == null ? void 0 : d.call(o)) == null ? void 0 : g.codeName;
        if (n) {
          const p = await ibiz.codeListService.get(
            n,
            e,
            s
          );
          if (p) {
            const f = /* @__PURE__ */ new Map();
            p.forEach((l) => {
              f.set(l.value, l.text);
            }), i.catalog = f;
          }
        }
        if (m) {
          const p = await ibiz.codeListService.get(
            m,
            e,
            s
          );
          if (p) {
            const f = /* @__PURE__ */ new Map();
            p.forEach((l) => {
              f.set(l.value, l.text);
            }), i.series = f;
          }
        }
        r[t] = i;
      })
    ), r;
  }
  /**
   * 生成数据集配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:37
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @return {*}
   */
  generateDatasetOption(e, s, r) {
    var a;
    const o = {}, t = [];
    o.source = t;
    const i = e.catalogField.toLowerCase(), n = e.valueField.toLowerCase(), m = (a = e.seriesField) == null ? void 0 : a.toLowerCase();
    if (m) {
      const c = /* @__PURE__ */ new Set();
      s.forEach((d) => {
        c.add(d[m]);
      }), t.push([i, ...c]);
    } else
      t.push([i, n]);
    t.push(
      ...s.map((c) => t[0].map((d, g) => g === 0 ? (r && r.catalog ? r.catalog.get(c[d]) : c[d]) || "未定义" : m ? d === c[m] && c[n] || 0 : c[n] || 0))
    ), r && r.series && (t[0] = t[0].map((c, d) => {
      var g;
      return d === 0 ? c : ((g = r.series) == null ? void 0 : g.get(c)) || c;
    }));
    for (let c = 1; c < t.length; c++)
      for (let d = c + 1; d < t.length; d++)
        t[d][0] === t[c][0] && (t[d].forEach((g, p) => {
          p !== 0 && (t[c][p] += g);
        }), t.splice(d, 1), d -= 1);
    return o;
  }
  /**
   * 生成图表配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:49
   * @param {IData[]} data
   * @param {IContext} context
   * @param {IParams} params
   * @return {*}
   */
  async generateChartOption(e, s, r) {
    const o = {};
    o.dataset = [], o.series = [];
    const t = await this.getAllCodeListMap(s, r);
    return this.seriesList.forEach((i, n) => {
      if (i.eChartsType === "radar") {
        const { series: a, radar: c } = this.generateRadarSeriesOption(
          i,
          e,
          t[n]
        );
        Array.isArray(o.series) && o.series.push(...a), o.radar = c;
        return;
      }
      const m = this.generateDatasetOption(i, e, t[n]);
      if (Array.isArray(o.dataset) && o.dataset.push(m), i.eChartsType === "bar") {
        const a = this.generateBarSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "line") {
        const a = this.generateLineSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "pie") {
        const a = this.generatePieSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "funnel") {
        const a = this.generateFunnelSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "scatter") {
        const a = this.generateScatterSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else
        throw new Error(`${i.eChartsType}类型的图表暂未实现`);
    }), o;
  }
  /**
   * 生成柱状图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:13
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateBarSeriesOption(e, s, r, o) {
    var p, f, l, C, w, x, b;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (p = e.seriesField) == null ? void 0 : p.toLowerCase(), c = +((C = (l = (f = e.M) == null ? void 0 : f.getPSChartSeriesEncode) == null ? void 0 : l.getPSChartXAxis) == null ? void 0 : C.id) || 0, d = +((b = (x = (w = e.M) == null ? void 0 : w.getPSChartSeriesEncode) == null ? void 0 : x.getPSChartYAxis) == null ? void 0 : b.id) || 0, g = {};
    if (a) {
      const E = /* @__PURE__ */ new Set();
      s.forEach((O) => {
        const A = O[a];
        E.add(r && r.series && r.series.get(A) || A);
      }), t.push(
        ...[...E].map((O) => ({
          type: i,
          xAxisIndex: c,
          yAxisIndex: d,
          name: O,
          datasetIndex: o,
          encode: {
            x: n,
            y: O
          },
          ...y(
            g,
            S(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        xAxisIndex: c,
        yAxisIndex: d,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: m
        },
        ...y(
          g,
          S(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成折线图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:32
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateLineSeriesOption(e, s, r, o) {
    var p, f, l, C, w, x, b;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (p = e.seriesField) == null ? void 0 : p.toLowerCase(), c = +((C = (l = (f = e.M) == null ? void 0 : f.getPSChartSeriesEncode) == null ? void 0 : l.getPSChartXAxis) == null ? void 0 : C.id) || 0, d = +((b = (x = (w = e.M) == null ? void 0 : w.getPSChartSeriesEncode) == null ? void 0 : x.getPSChartYAxis) == null ? void 0 : b.id) || 0, g = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const E = /* @__PURE__ */ new Set();
      s.forEach((O) => {
        const A = O[a];
        E.add(r && r.series && r.series.get(A) || A);
      }), t.push(
        ...[...E].map((O) => ({
          type: i,
          xAxisIndex: c,
          yAxisIndex: d,
          name: O,
          datasetIndex: o,
          encode: {
            x: n,
            y: O
          },
          stack: e.M.stack ? e.id : void 0,
          step: e.M.step ? "middle" : !1,
          ...y(
            g,
            S(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        xAxisIndex: c,
        yAxisIndex: d,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: m
        },
        ...y(
          g,
          S(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成饼图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:44
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generatePieSeriesOption(e, s, r, o) {
    var d;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (d = e.seriesField) == null ? void 0 : d.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        formatter: "{b}: {d}%({@age})",
        position: "outside",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((p) => {
        const f = p[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((p) => ({
          type: i,
          name: p,
          datasetIndex: o,
          encode: {
            itemName: n,
            value: p
          },
          ...y(
            c,
            S(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          itemName: n,
          value: m
        },
        ...y(
          c,
          S(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成漏斗图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:03
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateFunnelSeriesOption(e, s, r, o) {
    var d;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (d = e.seriesField) == null ? void 0 : d.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        formatter: "{b}: {d}%({@age})",
        position: "outside",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((p) => {
        const f = p[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((p) => ({
          type: i,
          name: p,
          datasetIndex: o,
          encode: {
            itemName: n,
            value: p
          },
          ...y(
            c,
            S(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          itemName: n,
          value: m
        },
        ...y(
          c,
          S(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成散点图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:25
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateScatterSeriesOption(e, s, r, o) {
    var d;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (d = e.seriesField) == null ? void 0 : d.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((p) => {
        const f = p[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((p) => ({
          type: i,
          name: p,
          datasetIndex: o,
          encode: {
            x: n,
            y: p
          },
          ...y(
            c,
            S(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: m
        },
        ...y(
          c,
          S(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成雷达图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:47
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @return {*}
   */
  generateRadarSeriesOption(e, s, r) {
    var f;
    const o = [], t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), m = e.valueField.toLowerCase(), a = (f = e.seriesField) == null ? void 0 : f.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const l = /* @__PURE__ */ new Set();
      s.forEach((C) => {
        l.add(C[a]);
      }), t.push([n, ...l]);
    } else
      t.push([n, m]);
    t.push(
      ...s.map((l) => t[0].map((C, w) => w === 0 ? (r && r.catalog ? r.catalog.get(l[C]) : l[C]) || "未定义" : a ? C === l[a] ? l[m] : 0 : l[m]))
    ), r && r.series && (t[0] = t[0].map((l, C) => {
      var w;
      return C === 0 ? l : ((w = r.series) == null ? void 0 : w.get(l)) || l;
    }));
    for (let l = 1; l < t.length; l++)
      for (let C = l + 1; C < t.length; C++)
        t[C][0] === t[l][0] && (t[C].forEach((w, x) => {
          x !== 0 && (t[l][x] += w);
        }), t.splice(C, 1), C -= 1);
    const d = t[0].slice(1).map((l, C) => t.slice(1).map((w) => w[C + 1]));
    o.push({
      type: i,
      name: e.caption || e.id,
      data: d,
      ...y(c, S(e.userParams))
    });
    let g = -1 / 0;
    d.forEach((l) => {
      l.forEach((C) => {
        +C > g && (g = +C);
      });
    });
    const p = t.slice(1).map((l) => ({
      name: l[0],
      max: g
    }));
    return {
      series: o,
      radar: {
        indicator: p
      }
    };
  }
}
class U extends z {
  constructor() {
    super(...arguments);
    /**
     * 图表实例
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:45
     * @type {(EChartsType | null)}
     */
    L(this, "chart", null);
    /**
     * 图表id
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:22
     * @type {string}
     */
    L(this, "chartId", `chart_${M()}`);
    /**
     * 图表静态配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:32
     * @type {EChartsOption}
     */
    L(this, "chartStaticOption", {});
    /**
     * 渲染前钩子函数
     *
     * @author zhanghengfeng
     * @date 2023-11-10 11:11:06
     */
    L(this, "hook");
    /**
     * 加载后处理钩子函数
     *
     * @author zhanghengfeng
     * @date 2023-11-16 17:11:13
     */
    L(this, "loadHook");
    /**
     * 数据集合
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:34
     * @type {IData[]}
     */
    L(this, "items", []);
    /**
     * 请求参数
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:28
     */
    L(this, "queryParams", {
      page: 0,
      size: 1e3,
      query: ""
    });
    /**
     * 图表部件宽度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:23
     * @type {string}
     */
    L(this, "width", "100%");
    /**
     * 图表部件高度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:37
     * @type {string}
     */
    L(this, "height", "100%");
  }
  /**
   * 创建图表神经系统
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:24
   * @protected
   * @return {*}  {ChartNerve}
   */
  createNerve() {
    return new H(this);
  }
  /**
   * 初始化配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:41
   * @protected
   * @return {*}  {Promise<void>}
   */
  async onInit() {
    await super.onInit(), this.service = new B(this.model), await this.service.init(this.context), this.initChartStaticOption(), this.resizeChart = this.resizeChart.bind(this), window.addEventListener("resize", this.resizeChart);
    const { width: e, height: s } = this.model.source;
    e && (this.width = `${e}px`), s && (this.height = `${s}px`);
  }
  /**
   * 重新渲染图表
   *
   * @author zhanghengfeng
   * @date 2023-04-03 18:04:35
   */
  resizeChart() {
    var e;
    (e = this.chart) == null || e.resize();
  }
  /**
   * 初始化图表静态配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:52
   */
  initChartStaticOption() {
    const e = {}, s = this.model.source.getPSDEChartTitle();
    e.title = s ? k(s) : {}, e.tooltip = {
      show: !0
    };
    const r = this.model.source.getPSDEChartSerieses();
    r && r.length && r[0].eChartsType === "bar" && (e.tooltip = {
      show: !0,
      padding: 0,
      backgroundColor: "rgba(255, 255, 255, 0)",
      borderWidth: 0,
      className: "chart-tooltip",
      borderRadius: 6,
      extraCssText: "box-shadow: none;",
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      },
      appendToBody: !0,
      formatter: (n) => {
        const m = n, a = document.createElement("div");
        if (a.classList.add("chart-tooltip-container"), Array.isArray(n)) {
          const c = [], d = /* @__PURE__ */ new Map();
          m.forEach((p) => {
            const f = p.seriesName, l = p.dimensionNames;
            l.slice(1).forEach((C, w) => {
              const x = l.length === 2 ? f : C, b = p.value[w + 1];
              d.has(x) || (c.push({
                x,
                y: b
              }), d.set(x, b));
            });
          });
          const g = document.createElement("div");
          return g.classList.add("chart-tooltip-title"), g.textContent = m[0].value[0], a.appendChild(g), c.forEach((p) => {
            const f = document.createElement("div");
            f.classList.add("chart-tooltip-item");
            const l = document.createElement("div");
            l.classList.add("chart-tooltip-item-name"), l.textContent = p.x, f.appendChild(l);
            const C = document.createElement("div");
            C.classList.add("chart-tooltip-item-number"), C.textContent = p.y, f.appendChild(C), a.appendChild(f);
          }), a;
        }
        return a;
      }
    });
    const o = this.model.source.getPSDEChartLegend();
    e.legend = o ? q(o) : {};
    const t = this.model.source.getPSChartXAxises();
    e.xAxis = t ? R(t) : [];
    const i = this.model.source.getPSChartYAxises();
    e.yAxis = i ? V(i) : [], Object.assign(
      this.chartStaticOption,
      y(e, S(this.model.source.userParams))
    );
  }
  /**
   * 注册渲染前钩子函数
   *
   * @author zhanghengfeng
   * @date 2023-11-14 10:11:42
   * @param {(_option: EChartsOption) => EChartsOption} hook
   */
  registerHook(e) {
    this.hook = e;
  }
  /**
   * 注册加载后处理钩子函数
   *
   * @author zhanghengfeng
   * @date 2023-11-16 17:11:13
   * @param {(_data: IData) => IData} hook
   */
  registerLoadHook(e) {
    this.loadHook = e;
  }
  /**
   * 加载数据
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:13
   * @param {IParams} params
   */
  async load() {
    var e;
    await this.startLoading();
    try {
      let { data: s } = await this.service.fetch(this.context, {
        ...this.params,
        ...this.queryParams
      });
      if (s = this.loadHook ? this.loadHook(s) : s, Array.isArray(s) && s.length) {
        if (this.items = s, !this.chart) {
          const i = document.querySelector(`#${this.chartId}`);
          if (!i)
            throw new Error("未找到ECharts绘制容器元素");
          this.chart = D(i);
        }
        const r = await this.service.generateChartOption(
          s,
          this.context,
          this.params
        ), o = y(
          this.chartStaticOption,
          r
        );
        let t = o;
        this.hook && (t = await this.hook(o)), this.chart.setOption(t);
      } else
        this.items = [], (e = this.chart) == null || e.clear();
    } finally {
      await this.endLoading();
    }
  }
  destroy() {
    var e;
    super.destroy(), (e = this.chart) == null || e.dispose(), window.removeEventListener("resize", this.resizeChart);
  }
}
function Q(h, u, e, s = {}) {
  return T(h, () => new U(u, e, s));
}
export {
  Q as u
};
