import { IPSChartAxis, IPSDEChartLegend, IPSDEChartTitle } from '@ibiz-template/model';
import { EChartsOption, LegendComponentOption, TitleComponentOption, XAXisComponentOption, YAXisComponentOption } from 'echarts';
/**
 * 解析自定义配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:52
 * @export
 * @param {IModel} userParams
 * @return {*}
 */
export declare function parseUserParams(userParams: IModel): EChartsOption;
/**
 * 生成标题配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:06
 * @export
 * @param {IPSDEChartTitle} chartTitle
 * @return {*}
 */
export declare function generateTitleOption(chartTitle: IPSDEChartTitle): TitleComponentOption;
/**
 * 生成图例配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:21
 * @export
 * @param {IPSDEChartLegend} chartLegend
 * @return {*}
 */
export declare function generateLegendOption(chartLegend: IPSDEChartLegend): LegendComponentOption;
/**
 * 生成坐标轴label配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:37
 * @export
 * @param {number} dataShowMode
 * @return {*}
 */
export declare function generateAxisLabelOption(dataShowMode: number): {
    axisLabel: {
        formatter: (value: string) => string;
        rotate: number;
    };
};
/**
 * 生成x轴配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:57
 * @export
 * @param {IPSChartAxis[]} chartXAxisList
 * @return {*}
 */
export declare function generateXAxisOption(chartXAxisList: IPSChartAxis[]): XAXisComponentOption[];
/**
 * 生成y轴配置
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:16
 * @export
 * @param {IPSChartAxis[]} chartYAxisList
 * @return {*}
 */
export declare function generateYAxisOption(chartYAxisList: IPSChartAxis[]): YAXisComponentOption[];
