import { PickerEditorModel } from '@ibiz-template/model';
import {
  FormItemController,
  GridEditItemController,
  IEditorProvider,
  PickerEditorController,
} from '@ibiz-template/controller';
/**
 * 数据选择器编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DataPickerEditorProvider
 * @implements {EditorProvider}
 */
export class DataPickerEditorProvider implements IEditorProvider {
  formEditor: string;

  gridEditor: string;

  constructor(editorType: string) {
    let componentName = 'IBizPicker';
    switch (editorType) {
      case 'PICKEREX_TRIGGER':
        componentName = 'IBizPickerDropDown';
        break;
      case 'PICKEREX_LINK':
        componentName = 'IBizPickerLink';
        break;
      case 'ADDRESSPICKUP':
        componentName = 'IBizMPicker';
        break;
      default:
    }
    this.formEditor = componentName;
    this.gridEditor = componentName;
  }

  async createController(
    editorModel: PickerEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<PickerEditorController> {
    const c = new PickerEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
