import {
  GridEditItemController,
  GridRowController,
} from '@ibiz-template/controller';
import { defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/grid/grid-edit-item.scss';
import { useNamespace } from '@ibiz-template/vue-util';

export const GridEditItem = defineComponent({
  name: 'GridEditItem',
  props: {
    controller: {
      type: GridEditItemController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-edit-item');
    // 编辑器值变更事件
    const rowDataChange = async (val: unknown, name?: string) => {
      const _name = name || props.controller.model.codeName;
      // 值不变则无后续,也不保存
      if (props.row.data[_name] === val) {
        return;
      }
      await props.controller.setRowValue(props.row, val, name);
      // 保存时机由界面控制
      await props.controller.grid.save(props.row.data);
    };

    const onStopPropagation = (e: MouseEvent) => {
      e.stopPropagation();
    };

    return { ns, rowDataChange, onStopPropagation };
  },
  render(h) {
    const codeName = this.controller.model.codeName;
    return (
      <appGridEditItem
        required={this.controller.required}
        error={this.row.errors[codeName]}
        nativeondblclick={this.onStopPropagation}
        nativeonClick={this.onStopPropagation}
      >
        {this.controller.editorProvider &&
          h(this.controller.editorProvider.gridEditor, {
            props: {
              value: this.row.data[codeName],
              data: this.row.data,
              controller: this.controller.editor,
              disabled: this.row.columnState[codeName]!.disabled,
              rowDataChange: this.rowDataChange.bind(this),
            },
          })}
      </appGridEditItem>
    );
  },
});
export default GridEditItem;
