import { DatePickerEditorController } from '@ibiz-template/controller';
import { ref, watch, defineComponent, PropType } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/editor/ibiz-date-picker/ibiz-date-picker.scss';

export const IBizDatePicker = defineComponent({
  name: 'IBizDatePicker',
  props: {
    value: {
      type: String,
    },
    controller: {
      type: DatePickerEditorController,
      required: true,
    },
    data: {
      type: Object as PropType<IData>,
    },
    disabled: {
      type: Boolean,
    },
  },
  emits: {
    change: (_value: string) => true,
  },
  setup(props, { emit }) {
    const ns = useNamespace('date-picker');
    const c = props.controller;

    const editorModel = c!.model;

    const type = ref('date');
    const format = ref('yyyy-MM-dd');

    switch (editorModel.editorType) {
      // 时间选择器
      case 'DATEPICKER':
        type.value = 'datetime';
        format.value = 'yyyy-MM-dd HH:mm:ss';
        break;
      // 时间选择控件
      case 'DATEPICKEREX':
        type.value = 'date';
        format.value = 'yyyy-MM-dd HH:mm:ss';
        break;
      // 时间选择控件_无小时
      case 'DATEPICKEREX_NOTIME':
        type.value = 'date';
        format.value = 'yyyy-MM-dd';
        break;
      // 时间选择控件_小时
      case 'DATEPICKEREX_HOUR':
        type.value = 'datetime';
        format.value = 'yyyy-MM-dd HH';
        break;
      // 时间选择控件_分钟
      case 'DATEPICKEREX_MINUTE':
        type.value = 'datetime';
        format.value = 'yyyy-MM-dd HH:mm';
        break;
      // 时间选择控件_秒钟
      case 'DATEPICKEREX_SECOND':
        type.value = 'datetime';
        format.value = 'yyyy-MM-dd HH:mm:ss';
        break;
      // 时间选择控件_无日期
      case 'DATEPICKEREX_NODAY':
        type.value = 'datetime';
        format.value = 'HH:mm:ss';
        break;
      // 时间选择控件_无日期无秒钟
      case 'DATEPICKEREX_NODAY_NOSECOND':
        type.value = 'datetime';
        format.value = 'HH:mm';
        break;
      // 时间选择控件_无秒钟
      case 'DATEPICKEREX_NOSECOND':
        type.value = 'datetime';
        format.value = 'yyyy-MM-dd HH:mm';
        break;
      default:
        break;
    }
    // 值格式化
    const valueFormat = c!.valueFormat;
    if (valueFormat) {
      const tempFormat: string = valueFormat
        .replace('YYYY', 'yyyy')
        .replace('DD', 'dd');
      format.value = tempFormat;
    }
    const currentVal = ref();
    watch(
      () => props.value,
      (newVal, oldVal) => {
        if (newVal !== oldVal) {
          currentVal.value = newVal || null;
        }
      },
      { immediate: true },
    );
    // 处理值变更
    const handleChange = (date: string, _dateType: IData) => {
      emit('change', date);
    };
    return { ns, c, editorModel, type, format, currentVal, handleChange };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <i-CalendarPicker
          type={this.type}
          format={this.format}
          placeholder={this.c!.placeHolder}
          value={this.currentVal}
          readonly={this.c!.model.readOnly}
          on-on-change={this.handleChange}
          disabled={this.disabled}
        ></i-CalendarPicker>
      </div>
    );
  },
});
