import { IModal } from '@ibiz-template/runtime';
import { usePickupGridViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const PickupGridView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;

    const c = usePickupGridViewController(proxy, props.modelPath);

    return { c };
  },
  render(h) {
    let gridComponent = null;
    if (this.c.complete) {
      const { grid } = this.c.model;
      if (this.c.providers[grid.name]) {
        gridComponent = h(this.c.providers[grid.name].component, {
          props: {
            modelData: grid,
            context: this.c.context,
            params: this.c.params,
            'grid-row-active-mode': this.c.model.gridRowActiveMode,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(grid.name),
          },
        });
      }
    }
    return <md-view-base controller={this.c}>{gridComponent}</md-view-base>;
  },
});
