/**
 * 网关注册中心服务
 *
 * @author chitanda
 * @date 2022-04-02 10:04:21
 * @export
 * @interface GatewayRegisterCenterService
 */
export interface GatewayRegisterCenterService {
  /**
   * 根据 service id 获取相关转发地址地址
   *
   * @author chitanda
   * @date 2022-04-02 10:04:07
   * @param {string} serviceId
   * @return {*}  {string[]}
   */
  getAddress(serviceId: string): string[];
  /**
   * 根据服务名称获取 ServiceId
   *
   * @author chitanda
   * @date 2022-04-02 10:04:38
   * @param {string} serviceName
   * @return {*}  {string}
   */
  getServiceId(serviceName: string): string;
}
