import { RawMaterialUIServiceBase } from './raw-material-ui-service-base';

/**
 * 原材料UI服务对象
 *
 * @export
 * @class RawMaterialUIService
 */
export default class RawMaterialUIService extends RawMaterialUIServiceBase {

    /**
     * 基础UI服务实例
     * 
     * @private
     * @type {ORDER1UIServiceBase}
     * @memberof RawMaterialUIService
     */
    private static basicUIServiceInstance: RawMaterialUIService;

    /**
     * 动态模型服务存储Map对象
     *
     * @private
     * @type {Map<string, any>}
     * @memberof RawMaterialUIService
     */
    private static UIServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  RawMaterialUIService.
     * 
     * @param {*} [opts={}]
     * @memberof  RawMaterialUIService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof RawMaterialUIService
     */
    public static getInstance(context: any): RawMaterialUIService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new RawMaterialUIService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!RawMaterialUIService.UIServiceMap.get(context.srfdynainstid)) {
                RawMaterialUIService.UIServiceMap.set(context.srfdynainstid, new RawMaterialUIService({context:context}));
            }
            return RawMaterialUIService.UIServiceMap.get(context.srfdynainstid);
        }
    }

}