import { FormButtonProvider } from './form-button-provider';
import { FormDRUIPartProvider } from './form-druipart-provider';
import { FormGroupPanelProvider } from './form-group-panel-provider';
import { FormItemProvider } from './form-item-provider';
import { FormPageProvider } from './form-page-provider';
import { FormRawItemProvider } from './form-raw-item-provider';
import { FormTabPageProvider } from './form-tab-page-provider';
import { FormTabPanelProvider } from './form-tab-panel-provider';

/**
 * 预置默认的表单成员适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:50
 * @export
 */
export function presetFormDetailProvider(): void {
  const { formDetail } = ibiz.register;
  if (!formDetail) {
    return;
  }
  // 表单项
  formDetail.register('FORMITEM', new FormItemProvider());
  // 表单分组
  formDetail.register('GROUPPANEL', new FormGroupPanelProvider());
  // 表单分页
  formDetail.register('FORMPAGE', new FormPageProvider());
  // 表单按钮
  formDetail.register('BUTTON', new FormButtonProvider());
  // 表单关系界面
  formDetail.register('DRUIPART', new FormDRUIPartProvider());
  // 表单直接内容
  formDetail.register('RAWITEM', new FormRawItemProvider());
  // 表单分页部件
  formDetail.register('TABPANEL', new FormTabPanelProvider());
  // 表单分页面板
  formDetail.register('TABPAGE', new FormTabPageProvider());
}

export {
  FormButtonProvider,
  FormDRUIPartProvider,
  FormGroupPanelProvider,
  FormItemProvider,
  FormPageProvider,
  FormRawItemProvider,
  FormTabPageProvider,
  FormTabPanelProvider,
};
