/**
 * 用户身份
 *
 * @author chitanda
 * @date 2021-08-22 15:08:14
 * @export
 * @class AuthenticationUser
 */
 export class AuthenticationUser {
  /**
   * 用戶标识
   */
  userid: string;
  /**
   * 用户全局名
   */
  username: string;
  /**
   * 员工标识
   */
  personid: string;
  /**
   * 用户姓名
   */
  personname: string;
  /**
   * 登录名
   */
  loginname: string;
  /**
   * 用户工号
   */
  usercode: string;
  /**
   * 登录密码
   */
  password: string;
  /**
   * 区属
   */
  domain: string;
  /**
   * 租户
   */
  srfdcid: string;
  /**
   * 系统标识
   */
  srfsystemid: string;
  /**
   * 租户系统标识
   */
  srfdcsystemid: string;
  /**
   * 动态实例标识
   */
  srfdynainstid: string;
  /**
   * 动态实例模型标识
   */
  srfdynamodelid: string;
  /**
   * 真实实例标识
   */
  srfrealdynainstid: string;
  /**
   * 动态实例标识
   */
  srfdynainsttag: string;
  /**
   * 动态实例标记2
   */
  srfdynainsttag2: string;
  /**
   * 部门标识
   */
  mdeptid: string;
  /**
   * 部门编码
   */
  mdeptcode: string;
  /**
   * 部门名称
   */
  mdeptname: string;
  /**
   * 业务编码
   */
  bcode: string;
  /**
   * 岗位标识
   */
  postid: string;
  /**
   * 岗位代码
   */
  postcode: string;
  /**
   * 岗位名称
   */
  postname: string;
  /**
   * 单位标识
   */
  orgid: string;
  /**
   * 单位编码
   */
  orgcode: string;
  /**
   * 单位名称
   */
  orgname: string;
  /**
   * 昵称别名
   */
  nickname: string;
  /**
   * 邮箱
   */
  email: string;
  /**
   * 社交账号
   */
  avatar: string;
  /**
   * 电话
   */
  phone: string;
  /**
   * 照片
   */
  usericon: string;
  /**
   * 性别
   */
  sex: string;
  /**
   * 出生日期
   */
  birthday: string;
  /**
   * 证件号码
   */
  certcode: string;
  /**
   * 地址
   */
  addr: string;
  /**
   * 主题
   */
  theme: string;
  /**
   * 字号
   */
  fontsize: string;
  /**
   * 语言
   */
  lang: string;
  /**
   * 备注
   */
  memo: string;
  /**
   * 保留字段
   */
  reserver: string;
  /**
   * 用户上下文参数
   */
  sessionParams: Record<string, any>;
  /**
   * 用户权限资源
   */
  authorities: any;
  /**
   * 是否为管理员
   */
  adminuser: number;
  /**
   * 是否为超级管理员
   */
  superuser: number;
  /**
   * 用户权限资源
   */
  permissionList: Record<string, any>;
  /**
   * 用户上下文参数
   */
  userSessionParam: Record<string, any>;
  /**
   * 当前用户上下级组织信息
   */
  orgInfo: Record<string, string[]>;
  /**
   * 上级组织
   */
  porg: string;
  /**
   * 下级组织
   */
  sorg: string;
  /**
   * 上级部门
   */
  pdept: string;
  /**
   * 下级部门
   */
  sdept: string;
  /**
   * 当前应用权限
   *
   * @author chitanda
   * @date 2021-10-19 10:10:27
   * @type {string[]}
   */
  uniRes: string[];

  /**
   * Creates an instance of AuthenticationUser.
   *
   * @author chitanda
   * @date 2021-08-22 16:08:57
   * @param {*} data
   */
  constructor(data: any) {
    Object.assign(this, data);
  }
}
