import {
  AppMenuPortletController,
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
} from '@ibiz-template/controller';
import { PortletPartModel, AppMenuPortletModel } from '@ibiz-template/model';

/**
 * 数据看板成员快捷菜单适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class AppMenuPortletProvider
 */
export class AppMenuPortletProvider implements IPortletPartProvider {
  compName: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<AppMenuPortletController> {
    const c = new AppMenuPortletController(
      portletModel as AppMenuPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
