import { FormRawItemModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormRawItemController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单项适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormRawItemProvider
 * @implements {EditorProvider}
 */
export class FormRawItemProvider implements IFormDetailProvider {
  compName: string = 'FormRawItem';

  async createController(
    detailModel: FormRawItemModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormRawItemController> {
    const c = new FormRawItemController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
