import { defineComponent } from 'vue';
import {
  getGridDropdownProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridDropdown = defineComponent({
  name: 'IBizGridDropdown',
  props: getGridDropdownProps(),
  setup(props) {
    const ns = useNamespace('grid-dropdown');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: props.controller.multiple,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <div
        ref='componentRef'
        class={`${this.ns.b()} ibiz-grid-editor`}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {h('IBizDropdown', {
          props: {
            ...this.$props,
            infoMode: this.isInfoMode,
            autoFocus: true,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </div>
    );
  },
});
