import { defineComponent, PropType } from 'vue';
import { IModal, Modal, ViewMode } from '@ibiz-template/runtime';

export const HomeView = defineComponent({
  name: 'HomeView',
  props: {
    modal: {
      type: Object as PropType<IModal>,
      required: true,
    },
  },
  setup(props) {
    const viewModal = new Modal({
      mode: ViewMode.ROUTE,
      viewUsage: 1,
      routeDepth: props.modal.routeDepth! + 1,
      dismiss: () => {
        props.modal.dismiss();
      },
    });
    return { viewModal };
  },
  render() {
    return <iBizRouterView modal={this.viewModal}></iBizRouterView>;
  },
});
