import { useNamespace, useRoute, useRouter } from '@ibiz-template/vue-util';
import { computed, defineComponent, getCurrentInstance, onMounted } from 'vue';
import '@/styles/components/views/404-view/404-view.scss';
import { Route } from 'vue-router';

export default defineComponent({
  setup() {
    const ns = useNamespace('404-view');
    const { proxy } = getCurrentInstance()!;
    const router = useRouter(proxy);
    const route = useRoute(proxy) as Route;
    const gotoIndexView = () => {
      router.push('/');
    };

    onMounted(() => {
      setTimeout(() => {
        const el = document.querySelector('.app-loading-x') as HTMLDivElement;
        if (el) {
          el.style.display = 'none';
        }
      }, 300);
    });

    const isView1 = computed(() => {
      return !route.params.view1;
    });

    return { ns, isView1, gotoIndexView };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <img class={this.ns.b('img')} src='./assets/img/404.png' />
        <div class={this.ns.b('text')}>
          <div class={this.ns.be('text', 'text1')}>
            抱歉，您访问的页面不存在！
          </div>
          {this.isView1 ? (
            <div class={this.ns.be('text', 'text2')}>
              您要找的页面不存在，请返回
              <a on-click={this.gotoIndexView}>首页</a>
              继续浏览
            </div>
          ) : null}
        </div>
      </div>
    );
  },
});
