import { defineComponent } from 'vue';
import {
  getGridInputNumberProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridInputNumber = defineComponent({
  name: 'IBizGridInputNumber',
  props: getGridInputNumberProps(),
  setup(props) {
    const ns = useNamespace('grid-input-number');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: true,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizInputNumber', {
          props: {
            ...this.$props,
            readonly: this.readonly || this.isInfoMode,
            disabled: this.disabled,
            autoFocus: true,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
