import { ContainerPortletModel, PortletPartModel } from '@ibiz-template/model';
import {
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
} from '@ibiz-template/controller';

/**
 * 数据看板容器适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ListPortletProvider
 */
export class ContainerPortletProvider implements IPortletPartProvider {
  component: string = 'PortletContainer';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ContainerPortletController> {
    const c = new ContainerPortletController(
      portletModel as ContainerPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
